/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import org.javers.core.diff.Change;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.ReferenceChange;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.diff.changetype.map.EntryAddOrRemove;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.diff.changetype.map.EntryValueChanged;
import org.javers.core.diff.changetype.map.MapChange;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.property.Entity;

public class ChangeTypeAdapter
implements JsonTypeAdapter<Change> {
    public static final Type[] SUPPORTED = new Type[]{NewObject.class, ObjectRemoved.class, ValueChange.class, ReferenceChange.class, MapChange.class};

    @Override
    public JsonElement toJson(Change change, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        this.appendChangeType(change, jsonObject);
        this.appendGlobalId(change.getGlobalCdoId(), jsonObject, context);
        if (change instanceof PropertyChange) {
            this.appendPropertyName((PropertyChange)change, jsonObject);
        }
        if (change instanceof ValueChange) {
            this.appendBody((ValueChange)change, jsonObject, context);
        }
        if (change instanceof ReferenceChange) {
            this.appendBody((ReferenceChange)change, jsonObject, context);
        }
        if (change instanceof MapChange) {
            this.appendBody((MapChange)change, jsonObject, context);
        }
        return jsonObject;
    }

    private void appendChangeType(Change change, JsonObject toJson) {
        toJson.addProperty("changeType", change.getClass().getSimpleName());
    }

    private void appendPropertyName(PropertyChange change, JsonObject toJson) {
        toJson.addProperty("property", change.getProperty().getName());
    }

    private void appendBody(ReferenceChange change, JsonObject toJson, JsonSerializationContext context) {
        toJson.add("leftReference", this.globalCdoId(change.getLeftReference(), context));
        toJson.add("rightReference", this.globalCdoId(change.getRightReference(), context));
    }

    private void appendBody(ValueChange change, JsonObject toJson, JsonSerializationContext context) {
        toJson.add("leftValue", context.serialize((Object)change.getWrappedLeftValue()));
        toJson.add("rightValue", context.serialize((Object)change.getWrappedRightValue()));
    }

    private void appendBody(MapChange change, JsonObject toJson, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (EntryChange entryChange : change.getEntryChanges()) {
            EntryChange entry;
            JsonObject entryElement = new JsonObject();
            entryElement.addProperty("entryChangeType", entryChange.getClass().getSimpleName());
            if (entryChange instanceof EntryAddOrRemove) {
                entry = (EntryAddOrRemove)entryChange;
                entryElement.add("key", context.serialize((Object)((EntryAddOrRemove)entry).getWrappedKey()));
                entryElement.add("value", context.serialize((Object)((EntryAddOrRemove)entry).getWrappedValue()));
            }
            if (entryChange instanceof EntryValueChanged) {
                entry = (EntryValueChanged)entryChange;
                entryElement.add("key", context.serialize((Object)((EntryValueChanged)entry).getWrappedKey()));
                entryElement.add("leftValue", context.serialize((Object)((EntryValueChanged)entry).getWrappedLeftValue()));
                entryElement.add("rightValue", context.serialize((Object)((EntryValueChanged)entry).getWrappedRightValue()));
            }
            jsonArray.add((JsonElement)entryElement);
        }
        toJson.add("entryChanges", (JsonElement)jsonArray);
    }

    private void appendGlobalId(GlobalCdoId globalCdoId, JsonObject toJson, JsonSerializationContext context) {
        toJson.add("globalCdoId", this.globalCdoId(globalCdoId, context));
    }

    private JsonElement globalCdoId(GlobalCdoId globalCdoId, JsonSerializationContext context) {
        if (globalCdoId == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (globalCdoId.getCdoClass() instanceof Entity) {
            jsonObject.addProperty("entity", globalCdoId.getCdoClass().getName());
        } else {
            jsonObject.addProperty("valueObject", globalCdoId.getCdoClass().getName());
        }
        if (globalCdoId.getCdoId() != null) {
            jsonObject.add("cdoId", context.serialize(globalCdoId.getCdoId()));
        }
        if (globalCdoId instanceof ValueObjectId) {
            ValueObjectId valueObjectId = (ValueObjectId)globalCdoId;
            jsonObject.add("ownerId", this.globalCdoId(valueObjectId.getOwnerId(), context));
            jsonObject.addProperty("fragment", valueObjectId.getFragment());
        }
        return jsonObject;
    }

    @Override
    public Change fromJson(JsonElement json, JsonDeserializationContext jsonDeserializationContext) {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Class getValueType() {
        return null;
    }
}

