/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.javers.common.collections.Maps;
import org.javers.common.collections.Objects;
import org.javers.common.collections.Sets;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.map.EntryAdded;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.diff.changetype.map.EntryRemoved;
import org.javers.core.diff.changetype.map.EntryValueChanged;
import org.javers.core.diff.changetype.map.MapChange;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapChangeAppender
extends PropertyChangeAppender<MapChange> {
    private static final Logger logger = LoggerFactory.getLogger(MapChangeAppender.class);
    private TypeMapper typeMapper;

    public MapChangeAppender(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    @Override
    protected boolean supports(JaversType propertyType) {
        if (!super.supports(propertyType)) {
            return false;
        }
        MapType mapType = (MapType)propertyType;
        boolean isSupported = this.typeMapper.isSupportedMap(mapType);
        if (!isSupported) {
            logger.warn("unsupported map content type [{}], skipping", (Object)propertyType.getBaseJavaType());
        }
        return isSupported;
    }

    @Override
    protected Class<? extends JaversType> getSupportedPropertyType() {
        return MapType.class;
    }

    @Override
    protected Collection<MapChange> calculateChanges(NodePair pair, Property property) {
        Map rightMap;
        Map leftMap = (Map)pair.getLeftPropertyValue(property);
        if (Objects.nullSafeEquals(leftMap, rightMap = (Map)pair.getRightPropertyValue(property))) {
            return Collections.EMPTY_SET;
        }
        ArrayList<EntryChange> changes = new ArrayList<EntryChange>();
        for (Object commonKey : Maps.commonKeys(leftMap, rightMap)) {
            Object rightVal;
            Object leftVal = leftMap.get(commonKey);
            if (Objects.nullSafeEquals(leftVal, rightVal = rightMap.get(commonKey))) continue;
            changes.add(new EntryValueChanged(commonKey, leftVal, rightVal));
        }
        for (Object addedKey : Maps.keysDifference(rightMap, leftMap)) {
            Object addedValue = rightMap.get(addedKey);
            changes.add(new EntryAdded(addedKey, addedValue));
        }
        for (Object removedKey : Maps.keysDifference(leftMap, rightMap)) {
            Object removedValue = leftMap.get(removedKey);
            changes.add(new EntryRemoved(removedKey, removedValue));
        }
        if (changes.size() > 0) {
            return Sets.asSet(new MapChange(pair.getGlobalCdoId(), property, changes));
        }
        return Collections.EMPTY_SET;
    }
}

