/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Transient;
import org.javers.core.metamodel.property.FieldProperty;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.property.PropertyScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldBasedPropertyScanner
implements PropertyScanner {
    private static final Logger logger = LoggerFactory.getLogger(FieldBasedPropertyScanner.class);

    @Override
    public List<Property> scan(Class<?> managedClass) {
        LinkedList<Field> declaredFields = new LinkedList<Field>();
        declaredFields.addAll(this.getFields(managedClass));
        ArrayList<Property> propertyList = new ArrayList<Property>(declaredFields.size());
        for (Field field : declaredFields) {
            if (!this.isPersistent(field)) continue;
            FieldProperty fieldProperty = new FieldProperty(field);
            propertyList.add(fieldProperty);
        }
        return propertyList;
    }

    private List<Field> getFields(Class<?> clazz) {
        List<Object> superFields = clazz.getSuperclass() == Object.class ? new ArrayList() : this.getFields(clazz.getSuperclass());
        superFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return superFields;
    }

    private boolean isPersistent(Field field) {
        return !Modifier.isTransient(field.getModifiers()) && field.getAnnotation(Transient.class) == null && !field.getName().equals("this$0");
    }
}

