/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.javers.common.validation.Validate;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.core.metamodel.property.EntityDefinition;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.ManagedClassDefinition;
import org.javers.core.metamodel.property.ManagedClassFactory;
import org.javers.core.metamodel.property.ValueObjectDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManager {
    private static final Logger logger = LoggerFactory.getLogger(EntityManager.class);
    private final ManagedClassFactory managedClassFactory;
    private final Set<ManagedClassDefinition> managedClassDefinitions = new HashSet<ManagedClassDefinition>();
    private final Map<Class, ManagedClass> managedClasses = new HashMap<Class, ManagedClass>();

    public EntityManager(ManagedClassFactory managedClassFactory) {
        Validate.argumentsAreNotNull(managedClassFactory);
        this.managedClassFactory = managedClassFactory;
    }

    public ManagedClass getByClass(Class<?> clazz) {
        if (!this.isRegistered(clazz)) {
            throw new JaversException(JaversExceptionCode.CLASS_NOT_MANAGED, clazz.getName());
        }
        return this.managedClasses.get(clazz);
    }

    public void register(ManagedClassDefinition def) {
        Validate.argumentIsNotNull(def);
        if (this.isRegistered(def)) {
            return;
        }
        this.managedClassDefinitions.add(def);
    }

    public void registerEntity(Class<?> clazz) {
        this.register(new EntityDefinition(clazz));
    }

    public void registerValueObject(Class<?> clazz) {
        this.register(new ValueObjectDefinition(clazz));
    }

    private boolean isRegistered(ManagedClassDefinition def) {
        return this.managedClassDefinitions.contains(def);
    }

    private boolean isRegistered(Class clazz) {
        for (ManagedClassDefinition def : this.managedClassDefinitions) {
            if (def.getClazz() != clazz) continue;
            return true;
        }
        return false;
    }

    public boolean isManaged(Class<?> clazz) {
        return this.managedClasses.containsKey(clazz);
    }

    public void buildManagedClasses() {
        for (ManagedClassDefinition def : this.managedClassDefinitions) {
            if (def instanceof EntityDefinition) {
                this.manageEntity((EntityDefinition)def);
            }
            if (!(def instanceof ValueObjectDefinition)) continue;
            this.manageValueObject((ValueObjectDefinition)def);
        }
    }

    private void manageEntity(EntityDefinition entityDef) {
        logger.debug("registering Entity[{}]", (Object)entityDef.getClazz().getName());
        this.managedClasses.put(entityDef.getClazz(), this.managedClassFactory.create(entityDef));
    }

    private void manageValueObject(ValueObjectDefinition voDef) {
        logger.debug("registering ValueObject[{}]", (Object)voDef.getClazz().getName());
        this.managedClasses.put(voDef.getClazz(), this.managedClassFactory.create(voDef));
    }
}

