/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.diff.NodePair;
import org.javers.core.metamodel.property.Property;
import org.javers.model.domain.GlobalCdoId;
import org.javers.model.object.graph.Edge;
import org.javers.model.object.graph.ObjectNode;
import org.javers.model.object.graph.SingleEdge;

public class RealNodePair
implements NodePair {
    private final ObjectNode left;
    private final ObjectNode right;

    public RealNodePair(ObjectNode left, ObjectNode right) {
        Validate.argumentsAreNotNull(left, right);
        Validate.argumentCheck(left.getGlobalCdoId().equals(right.getGlobalCdoId()), "left & right should refer to the same Cdo");
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean isNullOnBothSides(Property property) {
        return this.left.getPropertyValue(property) == null && this.right.getPropertyValue(property) == null;
    }

    @Override
    public Object getLeftPropertyValue(Property property) {
        return this.left.getPropertyValue(property);
    }

    @Override
    public Object getRightPropertyValue(Property property) {
        return this.right.getPropertyValue(property);
    }

    @Override
    public GlobalCdoId getRightGlobalCdoId(Property property) {
        return this.getGlobalCdoId(this.right.getEdge(property));
    }

    @Override
    public GlobalCdoId getLeftGlobalCdoId(Property property) {
        return this.getGlobalCdoId(this.left.getEdge(property));
    }

    public ObjectNode getLeft() {
        return this.left;
    }

    @Override
    public ObjectNode getRight() {
        return this.right;
    }

    @Override
    public List<Property> getProperties() {
        return this.left.getManagedClass().getProperties();
    }

    @Override
    public GlobalCdoId getGlobalCdoId() {
        return this.left.getGlobalCdoId();
    }

    private GlobalCdoId getGlobalCdoId(Edge edge) {
        return edge != null ? ((SingleEdge)edge).getReference().getGlobalCdoId() : null;
    }
}

