/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.property.EntityManager;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.model.mapping.type.TypeMapper;
import org.javers.model.object.graph.ObjectGraphBuilder;

public class Javers {
    private EntityManager entityManager;
    private DiffFactory diffFactory;
    private TypeMapper typeMapper;
    private JsonConverter jsonConverter;

    public Javers(EntityManager entityManager, DiffFactory diffFactory, TypeMapper typeMapper, JsonConverter jsonConverter) {
        this.entityManager = entityManager;
        this.diffFactory = diffFactory;
        this.typeMapper = typeMapper;
        this.jsonConverter = jsonConverter;
    }

    public ManagedClass getByClass(Class<?> forClass) {
        return this.entityManager.getByClass(forClass);
    }

    public boolean isManaged(Class<?> forClass) {
        return this.entityManager.isManaged(forClass);
    }

    public Diff initial(String user, Object root) {
        ObjectGraphBuilder graph = new ObjectGraphBuilder(this.entityManager, this.typeMapper);
        return this.diffFactory.createInitial(user, graph.buildGraph(root));
    }

    public Diff compare(String user, Object left, Object right) {
        ObjectGraphBuilder leftGraph = new ObjectGraphBuilder(this.entityManager, this.typeMapper);
        ObjectGraphBuilder rightGraph = new ObjectGraphBuilder(this.entityManager, this.typeMapper);
        return this.diffFactory.create(user, leftGraph.buildGraph(left), rightGraph.buildGraph(right));
    }

    public String toJson(Diff diff) {
        return this.jsonConverter.toJson(diff);
    }
}

