/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.model.mapping.ManagedClass;
import org.javers.model.mapping.Property;
import org.javers.model.mapping.type.CollectionType;
import org.javers.model.mapping.type.EntityReferenceType;

public class Entity<S>
extends ManagedClass<S> {
    private final Property idProperty;
    private final List<Property> properties;

    public Entity(Class<S> sourceClass, List<Property> properties, Property idProperty) {
        super(sourceClass);
        Validate.argumentIsNotNull(properties);
        this.properties = properties;
        this.idProperty = idProperty == null ? this.findDefaultIdProperty() : idProperty;
    }

    private Property findDefaultIdProperty() {
        for (Property p : this.properties) {
            if (!p.looksLikeId()) continue;
            return p;
        }
        throw new JaversException(JaversExceptionCode.ENTITY_WITHOUT_ID, this.sourceClass.getName());
    }

    public Object getCdoIdOf(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        Validate.argumentCheck(this.getSourceClass().isInstance(cdo), "expected instance of " + this.getSourceClass().getName() + ", got instance of " + cdo.getClass().getName());
        return this.getIdProperty().get(cdo);
    }

    @Override
    public boolean isInstance(Object cdo) {
        return this.getSourceClass().isInstance(cdo);
    }

    public Property getIdProperty() {
        return this.idProperty;
    }

    public List<Property> getSingleReferences() {
        ArrayList<Property> refProperties = new ArrayList<Property>();
        for (Property property : this.properties) {
            if (!(property.getType() instanceof EntityReferenceType)) continue;
            refProperties.add(property);
        }
        return refProperties;
    }

    public List<Property> getMultiReferences() {
        ArrayList<Property> refProperties = new ArrayList<Property>();
        for (Property property : this.properties) {
            if (!(property.getType() instanceof CollectionType)) continue;
            refProperties.add(property);
        }
        return refProperties;
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public Property getProperty(String withName) {
        Property found = null;
        for (Property property : this.properties) {
            if (!property.getName().equals(withName)) continue;
            found = property;
        }
        return found;
    }
}

