/*
 * Decompiled with CFR 0.152.
 */
package org.javers.json.typeAdapter;

import org.javers.json.BasicStringTypeAdapter;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class LocalDateTimeTypeAdapter
extends BasicStringTypeAdapter<LocalDateTime> {
    private static final DateTimeFormatter ISO_FORMATTER = ISODateTimeFormat.dateHourMinuteSecond();

    @Override
    public String serialize(LocalDateTime sourceValue) {
        return ISO_FORMATTER.print((ReadablePartial)sourceValue);
    }

    @Override
    public LocalDateTime deserialize(String serializedValue) {
        return ISO_FORMATTER.parseLocalDateTime(serializedValue);
    }

    @Override
    public Class<LocalDateTime> getType() {
        return LocalDateTime.class;
    }
}

