/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.object.graph;

import java.util.ArrayList;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.model.domain.Cdo;
import org.javers.model.domain.GlobalCdoId;
import org.javers.model.mapping.Entity;
import org.javers.model.mapping.Property;
import org.javers.model.object.graph.Edge;
import org.javers.model.object.graph.GraphVisitor;
import org.javers.model.object.graph.ObjectNode;

public class ObjectWrapper
implements ObjectNode {
    private final Cdo cdo;
    private final List<Edge> edges;

    public ObjectWrapper(Cdo cdo) {
        Validate.argumentIsNotNull(cdo);
        this.cdo = cdo;
        this.edges = new ArrayList<Edge>();
    }

    @Deprecated
    public ObjectWrapper(Object cdo, Entity entity) {
        this(new Cdo(cdo, entity));
    }

    public Object unwrapCdo() {
        return this.cdo.getWrappedCdo();
    }

    @Override
    public Cdo getCdo() {
        return this.cdo;
    }

    @Override
    public Object getPropertyValue(Property property) {
        Validate.argumentIsNotNull(property);
        return property.get(this.unwrapCdo());
    }

    @Override
    public Object getLocalCdoId() {
        return this.cdo.getLocalId();
    }

    @Override
    public GlobalCdoId getGlobalCdoId() {
        return this.cdo.getGlobalId();
    }

    @Override
    public Entity getEntity() {
        return this.cdo.getEntity();
    }

    @Override
    public List<Edge> getEdges() {
        return this.edges;
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectWrapper that = (ObjectWrapper)o;
        return this.cdo.equals(that.cdo);
    }

    public int hashCode() {
        return this.cdo.hashCode();
    }

    @Override
    public void accept(GraphVisitor visitor) {
        if (visitor.wasVisited(this)) {
            return;
        }
        visitor.visit(this);
        for (Edge edge : this.edges) {
            edge.accept(visitor);
        }
    }
}

