/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.object.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javers.common.validation.Validate;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.model.domain.Cdo;
import org.javers.model.mapping.Entity;
import org.javers.model.mapping.EntityManager;
import org.javers.model.mapping.ManagedClass;
import org.javers.model.mapping.Property;
import org.javers.model.mapping.ValueObject;
import org.javers.model.object.graph.MultiEdge;
import org.javers.model.object.graph.ObjectNode;
import org.javers.model.object.graph.ObjectWrapper;
import org.javers.model.object.graph.SingleEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectGraphBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ObjectGraphBuilder.class);
    private final EntityManager entityManager;
    private boolean built;
    private Map<Cdo, ObjectWrapper> reverseCdoIdMap;

    public ObjectGraphBuilder(EntityManager entityManager) {
        this.entityManager = entityManager;
        this.reverseCdoIdMap = new HashMap<Cdo, ObjectWrapper>();
    }

    public ObjectNode buildGraph(Object cdo) {
        ObjectNode root = this.buildNode(this.asCdo(cdo));
        logger.debug("done building objectGraph for root [" + root + "], nodes: " + this.reverseCdoIdMap.size());
        this.switchToBuilt();
        return root;
    }

    private ObjectNode buildNode(Cdo cdo) {
        Validate.argumentIsNotNull(cdo);
        ObjectWrapper node = this.buildNodeStubAndSaveForReuse(cdo);
        this.buildEdges(node);
        return node;
    }

    private void switchToBuilt() {
        if (this.built) {
            throw new IllegalStateException("ObjectGraphBuilder is stateful builder (not a Service)");
        }
        this.built = true;
    }

    private void buildEdges(ObjectWrapper node) {
        this.buildSingleEdges(node);
        this.buildMultiEdges(node);
    }

    private void buildSingleEdges(ObjectWrapper node) {
        List<Property> singleReferences = node.getEntity().getSingleReferences();
        for (Property singleRef : singleReferences) {
            if (singleRef.isNull(node.unwrapCdo())) continue;
            Object referencedRawCdo = singleRef.get(node.unwrapCdo());
            ObjectNode referencedNode = this.buildNodeOrReuse(this.asCdo(referencedRawCdo));
            SingleEdge edge = new SingleEdge(singleRef, referencedNode);
            node.addEdge(edge);
        }
    }

    private void buildMultiEdges(ObjectWrapper node) {
        List<Property> multiReferences = node.getEntity().getMultiReferences();
        for (Property multiRef : multiReferences) {
            Collection collectionOfReferences;
            if (multiRef.isNull(node.unwrapCdo()) || (collectionOfReferences = (Collection)multiRef.get(node.unwrapCdo())).isEmpty()) continue;
            MultiEdge multiEdge = this.createMultiEdge(multiRef, collectionOfReferences);
            node.addEdge(multiEdge);
        }
    }

    private MultiEdge createMultiEdge(Property multiRef, Collection collectionOfReferences) {
        MultiEdge multiEdge = new MultiEdge(multiRef);
        for (Object referencedRawCdo : collectionOfReferences) {
            ObjectNode objectNode = this.buildNodeOrReuse(this.asCdo(referencedRawCdo));
            multiEdge.addReferenceNode(objectNode);
        }
        return multiEdge;
    }

    private ObjectWrapper buildNodeStubAndSaveForReuse(Cdo cdo) {
        ObjectWrapper nodeStub = new ObjectWrapper(cdo);
        this.reverseCdoIdMap.put(cdo, nodeStub);
        return nodeStub;
    }

    private ObjectNode buildNodeOrReuse(Cdo referencedCdo) {
        if (this.reverseCdoIdMap.containsKey(referencedCdo)) {
            return this.reverseCdoIdMap.get(referencedCdo);
        }
        return this.buildNode(referencedCdo);
    }

    private Cdo asCdo(Object cdo) {
        return new Cdo(cdo, this.getEntity(cdo));
    }

    private Entity getEntity(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        ManagedClass managedClass = this.entityManager.getByClass(cdo.getClass());
        if (managedClass instanceof ValueObject) {
            throw new JaversException(JaversExceptionCode.UNEXPECTED_VALUE_OBJECT, cdo.getClass().getName());
        }
        return (Entity)managedClass;
    }
}

