/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.domain;

import org.javers.common.validation.Validate;
import org.javers.model.domain.GlobalCdoId;
import org.javers.model.mapping.Entity;

public class Cdo {
    private final Object wrappedCdo;
    private final GlobalCdoId globalId;

    public Cdo(Object cdo, Entity entity) {
        Validate.argumentIsNotNull(cdo);
        Validate.argumentIsNotNull(entity);
        Validate.argumentCheck(entity.isInstance(cdo), "cdo is not an instance of entity");
        this.wrappedCdo = cdo;
        this.globalId = new GlobalCdoId(entity.getCdoIdOf(cdo), entity);
    }

    public Object getWrappedCdo() {
        return this.wrappedCdo;
    }

    public GlobalCdoId getGlobalId() {
        return this.globalId;
    }

    public Object getLocalId() {
        return this.globalId.getLocalCdoId();
    }

    public Entity getEntity() {
        return this.globalId.getEntity();
    }

    public String toString() {
        return this.globalId.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Cdo)) {
            return false;
        }
        Cdo other = (Cdo)o;
        return this.globalId.equals(other.globalId);
    }

    public int hashCode() {
        return this.globalId.hashCode();
    }
}

