/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.object.graph;

import java.util.Collection;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.model.mapping.EntityManager;
import org.javers.model.mapping.Property;
import org.javers.model.object.graph.MultiEdge;
import org.javers.model.object.graph.ObjectNode;
import org.javers.model.object.graph.ObjectWrapper;
import org.javers.model.object.graph.SingleEdge;

public class ObjectGraphBuilder {
    protected final EntityManager entityManager;

    public ObjectGraphBuilder(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public ObjectNode build(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        ObjectWrapper node = new ObjectWrapper(cdo, this.entityManager.getByClass(cdo.getClass()));
        this.initEdges(node);
        return node;
    }

    private void initEdges(ObjectWrapper node) {
        this.initSingleEdge(node);
        this.initMultiEdge(node);
    }

    private void initMultiEdge(ObjectWrapper node) {
        List<Property> multiReferences = node.getEntity().getMultiReferences();
        for (Property multiRef : multiReferences) {
            if (multiRef.isNull(node.getCdo())) continue;
            Object collectionRefCod = multiRef.get(node.getCdo());
            MultiEdge multiEdge = this.createMultiEdge(multiRef, collectionRefCod);
            node.addEdge(multiEdge);
        }
    }

    private MultiEdge createMultiEdge(Property multiRef, Object referencedCdo) {
        MultiEdge multiEdge = new MultiEdge(multiRef);
        for (Object o : (Collection)referencedCdo) {
            ObjectNode objectNode = this.build(o);
            multiEdge.addReferenceNode(objectNode);
        }
        return multiEdge;
    }

    private void initSingleEdge(ObjectWrapper node) {
        List<Property> singleReferences = node.getEntity().getSingleReferences();
        for (Property singleRef : singleReferences) {
            if (singleRef.isNull(node.getCdo())) continue;
            Object referencedCdo = singleRef.get(node.getCdo());
            ObjectWrapper referencedNode = (ObjectWrapper)this.build(referencedCdo);
            SingleEdge edge = new SingleEdge(singleRef, referencedNode);
            node.addEdge(edge);
        }
    }
}

