/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.model.mapping.type.ArrayType;
import org.javers.model.mapping.type.CollectionType;
import org.javers.model.mapping.type.EntityReferenceType;
import org.javers.model.mapping.type.JaversType;
import org.javers.model.mapping.type.PrimitiveType;
import org.javers.model.mapping.type.ValueObjectType;

public class TypeMapper {
    private List<JaversType> mappedTypes = new ArrayList<JaversType>();

    public TypeMapper() {
        this.registerPrimitiveType(Integer.TYPE);
        this.registerPrimitiveType(Boolean.TYPE);
        this.registerPrimitiveType(Double.TYPE);
        this.registerPrimitiveType(Float.TYPE);
        this.registerPrimitiveType(Long.TYPE);
        this.registerPrimitiveType(Integer.class);
        this.registerPrimitiveType(Boolean.class);
        this.registerPrimitiveType(Double.class);
        this.registerPrimitiveType(Float.class);
        this.registerPrimitiveType(String.class);
        this.registerPrimitiveType(Enum.class);
        this.registerPrimitiveType(Long.class);
        this.addType(new CollectionType(Set.class));
        this.addType(new CollectionType(List.class));
        this.addType(new ArrayType());
    }

    public JaversType getJavesrType(Class javaType) {
        JaversType mappedType = this.findJavesType(javaType);
        if (mappedType != null) {
            return mappedType;
        }
        throw new JaversException(JaversExceptionCode.TYPE_NOT_MAPPED, javaType.getName());
    }

    public boolean isMapped(Class javaType) {
        return this.findJavesType(javaType) != null;
    }

    private JaversType findJavesType(Class javaType) {
        for (JaversType mappedType : this.mappedTypes) {
            if (!mappedType.isMappingForJavaType(javaType)) continue;
            return mappedType;
        }
        return null;
    }

    private void addType(JaversType type) {
        this.mappedTypes.add(type);
    }

    public void registerPrimitiveType(Class<?> primitiveClass) {
        this.addType(new PrimitiveType(primitiveClass));
    }

    public void registerReferenceType(Class<?> entityClass) {
        this.addType(new EntityReferenceType(entityClass));
    }

    public void registerValueObjectType(Class<?> objectValue) {
        this.addType(new ValueObjectType(objectValue));
    }

    public List<Class> getReferenceTypes() {
        ArrayList<Class> referenceClasses = new ArrayList<Class>();
        for (JaversType entry : this.mappedTypes) {
            if (!(entry instanceof EntityReferenceType)) continue;
            referenceClasses.add(entry.getBaseJavaType());
        }
        return referenceClasses;
    }
}

