/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.model.mapping.Entity;
import org.javers.model.mapping.Property;
import org.javers.model.mapping.type.CollectionType;
import org.javers.model.mapping.type.EntityReferenceType;

public abstract class ManagedClass<S> {
    protected final Class<S> sourceClass;
    protected final List<Property> properties;

    public ManagedClass(Class<S> sourceClass, List<Property> properties) {
        Validate.argumentIsNotNull(sourceClass);
        Validate.argumentIsNotNull(properties);
        this.sourceClass = sourceClass;
        this.properties = properties;
    }

    public boolean isInstance(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        return this.sourceClass.isAssignableFrom(cdo.getClass());
    }

    public Class<S> getSourceClass() {
        return this.sourceClass;
    }

    public List<Property> getSingleReferences() {
        ArrayList<Property> refProperties = new ArrayList<Property>();
        for (Property property : this.properties) {
            if (!(property.getType() instanceof EntityReferenceType)) continue;
            refProperties.add(property);
        }
        return refProperties;
    }

    public List<Property> getMultiReferences() {
        ArrayList<Property> refProperties = new ArrayList<Property>();
        for (Property property : this.properties) {
            if (!(property.getType() instanceof CollectionType)) continue;
            refProperties.add(property);
        }
        return refProperties;
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public Property getProperty(String withName) {
        Property found = null;
        for (Property property : this.properties) {
            if (!property.getName().equals(withName)) continue;
            found = property;
        }
        return found;
    }

    public int hashCode() {
        return this.sourceClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Entity)) {
            return false;
        }
        return this.sourceClass.equals((ManagedClass)obj) && this.properties.equals(((ManagedClass)obj).getProperties());
    }
}

