/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping;

import java.util.HashMap;
import java.util.Map;
import org.javers.common.validation.Validate;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.model.mapping.Entity;
import org.javers.model.mapping.EntityFactory;

public class EntityManager {
    private EntityFactory entityFactory;
    private Map<Class<?>, Entity> managedEntities = new HashMap();

    public EntityManager(EntityFactory entityFactory) {
        Validate.argumentIsNotNull(entityFactory);
        this.entityFactory = entityFactory;
    }

    public Entity getByClass(Class<?> forClass) {
        if (!this.isRegisterd(forClass)) {
            throw new JaversException(JaversExceptionCode.CLASS_NOT_MANAGED, forClass.getName());
        }
        if (this.isRegisterd(forClass) && !this.isManaged(forClass)) {
            throw new JaversException(JaversExceptionCode.ENTITY_MANAGER_NOT_INITIALIZED, forClass.getName());
        }
        return this.managedEntities.get(forClass);
    }

    public void registerEntity(Class<?> classToManage) {
        Validate.argumentIsNotNull(classToManage);
        if (this.isRegisterd(classToManage)) {
            return;
        }
        this.entityFactory.typeMapper.registerReferenceType(classToManage);
    }

    public void registerValueObject(Class<?> classToManage) {
        Validate.argumentIsNotNull(classToManage);
        if (this.isRegisterd(classToManage)) {
            return;
        }
        this.entityFactory.typeMapper.registerValueObjectType(classToManage);
    }

    private boolean isRegisterd(Class<?> managedClass) {
        return this.entityFactory.typeMapper.isMapped(managedClass);
    }

    public boolean isManaged(Class<?> managedClass) {
        return this.managedEntities.containsKey(managedClass);
    }

    public void buildManagedClasses() {
        for (Class referenceClass : this.entityFactory.typeMapper.getReferenceTypes()) {
            Entity entity = this.entityFactory.createEntity(referenceClass);
            this.managedEntities.put(referenceClass, entity);
        }
    }
}

