/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.model.domain.Change;
import org.joda.time.LocalDateTime;

public class Diff {
    private long id;
    private final List<Change> changes;
    private final String userId;
    private final LocalDateTime diffDate;

    public Diff(String userId) {
        Validate.argumentIsNotNull(userId);
        this.userId = userId;
        this.diffDate = new LocalDateTime();
        this.changes = new ArrayList<Change>();
    }

    public long getId() {
        return this.id;
    }

    void assignId(long id) {
        Validate.argumentCheck(id > 0L, "id should be positive long");
        Validate.conditionFulfilled(this.isNew(), "id already assigned");
        this.id = id;
    }

    public String getUserId() {
        return this.userId;
    }

    public LocalDateTime getDiffDate() {
        return this.diffDate;
    }

    public List<Change> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public boolean isNew() {
        return this.id == 0L;
    }

    public void addChange(Change change) {
        this.changes.add(change);
    }
}

