/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Transient;

public class ReflectionUtil {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static List<Method> findAllPersistentGetters(Class methodSource) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : ReflectionUtil.getAllMethods(methodSource)) {
            if (!ReflectionUtil.isPersistentGetter(m)) continue;
            result.add(m);
        }
        return result;
    }

    public static List<Method> getAllMethods(Class methodSource) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class clazz = methodSource; clazz != null; clazz = clazz.getSuperclass()) {
            for (Method m : clazz.getDeclaredMethods()) {
                methods.add(m);
            }
        }
        return methods;
    }

    public static boolean isPersistentGetter(Method m) {
        if (!ReflectionUtil.isGetter(m)) {
            return false;
        }
        return !m.isAnnotationPresent(Transient.class) && !Modifier.isAbstract(m.getModifiers()) && !Modifier.isNative(m.getModifiers());
    }

    public static boolean isGetter(Method m) {
        return (m.getName().substring(0, 3).equals("get") || m.getName().substring(0, 2).equals("is")) && m.getParameterTypes().length == 0;
    }

    public static String getterToField(Method getter) {
        if (getter.getName().substring(0, 3).equals("get")) {
            return getter.getName().substring(3, 4).toLowerCase() + getter.getName().substring(4);
        }
        if (getter.getName().substring(0, 2).equals("is")) {
            return getter.getName().substring(2, 3).toLowerCase() + getter.getName().substring(3);
        }
        throw new IllegalArgumentException("Method [" + getter + "] is not getter");
    }

    public static Object invokeGetter(Method getter, Object onObject) {
        try {
            return getter.invoke(onObject, EMPTY_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException("error calling getter '" + getter + "'", e);
        }
    }

    public static Object invokeGetterEvenIfPrivate(Method getter, Object onObject) {
        ReflectionUtil.setAccessibleIfPrivateOrProtected(getter);
        return ReflectionUtil.invokeGetter(getter, onObject);
    }

    public static Object invokeFieldEvenIfPrivate(Field field, Object onObject) {
        ReflectionUtil.setAccessibleIfPrivateOrProtected(field);
        return ReflectionUtil.invokeField(field, onObject);
    }

    public static Object invokeField(Field field, Object onObject) {
        try {
            return field.get(onObject);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("error getting value from field '" + field.getName() + "'");
        }
    }

    private static boolean isPrivateOrProtected(int modifiersCode) {
        return Modifier.isPrivate(modifiersCode) || Modifier.isProtected(modifiersCode);
    }

    private static <T extends AccessibleObject> void setAccessibleIfPrivateOrProtected(T object) {
        if (ReflectionUtil.isPrivateOrProtected(((Member)((Object)object)).getModifiers())) {
            object.setAccessible(true);
        }
    }

    public static Class getGenericTypeClass(Type type) {
        if (type instanceof ParameterizedType) {
            return ReflectionUtil.getClassFromParametrizedTypeArgument((ParameterizedType)type);
        }
        throw new IllegalArgumentException("Error can not get any additional data from this type " + type.getClass() + ".\nArgument type (java.lang.reflect.Type) should be obtain by invoke java.lang.reflect.Field.getGenericType() or java.lang.reflect.Method.getGenericReturnType()" + "\nFor example ReflectionUtil.getGeneticTypeClass(someReflectField.getGenericType())");
    }

    private static Class getClassFromParametrizedTypeArgument(ParameterizedType type) {
        Type[] actualTypeArguments = type.getActualTypeArguments();
        if (actualTypeArguments.length > 1) {
            throw new IllegalArgumentException("Error can not determine actual element type. Number of type should by 1 is " + actualTypeArguments.length);
        }
        return (Class)actualTypeArguments[0];
    }
}

