/*
 * Decompiled with CFR 0.152.
 */
package org.javaz.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.javaz.cache.CacheI;

public class CacheImpl
implements CacheI {
    private static final long NO_OBJECTS = -1L;
    private long timeToLive = 0L;
    private final Integer CLEAR_LOCK = 100500;
    private Integer LOCK_STATE = 0;
    private static final Integer LOCK_STATE_UNLOCKED = 0;
    private static final Integer LOCK_STATE_LOCKED = 1;
    private long nextTimeSomeExpired = -1L;
    private final HashMap objects = new HashMap();
    private final HashMap<Object, Long> objectTimeStamps = new HashMap();

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public void setTimeToLive(long timeToLive) {
        boolean needRecheckNextExpire = this.timeToLive != timeToLive;
        this.timeToLive = timeToLive;
        if (needRecheckNextExpire) {
            this.findNextExpireTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        long objectStamp = System.currentTimeMillis();
        HashMap hashMap = this.objects;
        synchronized (hashMap) {
            this.objectTimeStamps.put(key, objectStamp);
            if (this.nextTimeSomeExpired == -1L) {
                this.nextTimeSomeExpired = objectStamp;
            }
            return this.objects.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearExpired() {
        Integer n = this.CLEAR_LOCK;
        synchronized (n) {
            if (this.LOCK_STATE.equals(LOCK_STATE_LOCKED)) {
                return;
            }
            this.LOCK_STATE = LOCK_STATE_LOCKED;
        }
        long expireRunStamp = System.currentTimeMillis();
        if (this.nextTimeSomeExpired != -1L && expireRunStamp >= this.nextTimeSomeExpired) {
            HashMap hashMap = this.objects;
            synchronized (hashMap) {
                try {
                    ArrayList set = new ArrayList(this.objects.keySet());
                    for (Object key : set) {
                        Long timeToExpire = this.objectTimeStamps.get(key) + this.timeToLive;
                        if (timeToExpire >= expireRunStamp) continue;
                        this.objects.remove(key);
                        this.objectTimeStamps.remove(key);
                    }
                    this.findNextExpireTime();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.LOCK_STATE = LOCK_STATE_UNLOCKED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        HashMap hashMap = this.objects;
        synchronized (hashMap) {
            this.objectTimeStamps.clear();
            this.objects.clear();
            this.nextTimeSomeExpired = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.clearExpired();
        HashMap hashMap = this.objects;
        synchronized (hashMap) {
            return this.objects.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        this.clearExpired();
        HashMap hashMap = this.objects;
        synchronized (hashMap) {
            return this.objects.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        this.clearExpired();
        HashMap hashMap = this.objects;
        synchronized (hashMap) {
            return this.objects.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.clearExpired();
        HashMap hashMap = this.objects;
        synchronized (hashMap) {
            return this.objects.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        HashMap hashMap = this.objects;
        synchronized (hashMap) {
            Object remove = this.objects.remove(key);
            this.objectTimeStamps.remove(key);
            if (remove != null) {
                this.findNextExpireTime();
            }
            return remove;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.clearExpired();
        HashMap hashMap = this.objects;
        synchronized (hashMap) {
            return this.objects.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findNextExpireTime() {
        if (this.objects.size() == 0) {
            this.nextTimeSomeExpired = -1L;
        } else {
            this.nextTimeSomeExpired = -1L;
            ArrayList<Long> longs = null;
            HashMap hashMap = this.objects;
            synchronized (hashMap) {
                longs = new ArrayList<Long>(this.objectTimeStamps.values());
            }
            Iterator iterator = longs.iterator();
            while (iterator.hasNext()) {
                Long next = (Long)iterator.next() + this.timeToLive;
                if (this.nextTimeSomeExpired != -1L && next >= this.nextTimeSomeExpired) continue;
                this.nextTimeSomeExpired = next;
            }
        }
    }
}

