/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.swift;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.javaswift.joss.command.mock.core.CommandMock;
import org.javaswift.joss.command.shared.identity.tenant.Tenant;
import org.javaswift.joss.command.shared.identity.tenant.Tenants;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.headers.Header;
import org.javaswift.joss.headers.account.AccountBytesUsed;
import org.javaswift.joss.headers.account.AccountContainerCount;
import org.javaswift.joss.headers.account.AccountObjectCount;
import org.javaswift.joss.headers.account.HashPassword;
import org.javaswift.joss.headers.account.ServerDate;
import org.javaswift.joss.headers.object.DeleteAfter;
import org.javaswift.joss.headers.object.DeleteAt;
import org.javaswift.joss.headers.object.ObjectManifest;
import org.javaswift.joss.information.AccountInformation;
import org.javaswift.joss.information.ContainerInformation;
import org.javaswift.joss.information.ObjectInformation;
import org.javaswift.joss.instructions.DownloadInstructions;
import org.javaswift.joss.instructions.ListInstructions;
import org.javaswift.joss.instructions.UploadInstructions;
import org.javaswift.joss.model.Access;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.Container;
import org.javaswift.joss.model.DirectoryOrObject;
import org.javaswift.joss.model.StoredObject;
import org.javaswift.joss.swift.HeaderStore;
import org.javaswift.joss.swift.MockInputStreamWrapper;
import org.javaswift.joss.swift.MockUserStore;
import org.javaswift.joss.swift.OnFileObjectStoreLoader;
import org.javaswift.joss.swift.PageServer;
import org.javaswift.joss.swift.SwiftContainer;
import org.javaswift.joss.swift.SwiftResult;
import org.javaswift.joss.swift.SwiftStoredObject;
import org.javaswift.joss.swift.scheduled.ObjectDeleter;
import org.javaswift.joss.swift.statusgenerator.StatusGenerator;
import org.javaswift.joss.util.LocalTime;

public class Swift {
    private Map<String, SwiftContainer> containers = new TreeMap<String, SwiftContainer>();
    private boolean allowObjectDeleter;
    private ObjectDeleter objectDeleter;
    private MockUserStore users = new MockUserStore();
    private String publicHost;
    private String privateHost;
    private HeaderStore headers = new HeaderStore();
    private long millisDelay = 0L;
    private int objectDeleterStartAfterSeconds = 10;
    private int objectDeleterIntervalSeconds = 10;
    private boolean tenantSupplied = false;
    private Character delimiter = Character.valueOf('/');
    StatusGenerator statusGenerator = new StatusGenerator();

    public Swift setOnFileObjectStore(Class mockClasspath, String onFileObjectStore, boolean absolutePath) {
        if (onFileObjectStore == null) {
            return this;
        }
        OnFileObjectStoreLoader loader = new OnFileObjectStoreLoader();
        try {
            this.containers = loader.createContainers(mockClasspath, onFileObjectStore, absolutePath);
        }
        catch (Exception err) {
            throw new CommandException("Unable to load the object store from file: " + err.getMessage(), err);
        }
        return this;
    }

    public boolean isObjectDeleterActive() {
        return this.objectDeleter != null && !this.objectDeleter.isShutdown();
    }

    public ObjectDeleter getCurrentObjectDeleter() {
        if (!this.allowObjectDeleter) {
            return null;
        }
        if (!this.isObjectDeleterActive()) {
            this.objectDeleter = new ObjectDeleter(this.objectDeleterStartAfterSeconds, this.objectDeleterIntervalSeconds);
        }
        return this.objectDeleter;
    }

    public Swift setAllowObjectDeleter(boolean allowObjectDeleter) {
        this.allowObjectDeleter = allowObjectDeleter;
        return this;
    }

    public Swift setUserStore(MockUserStore users) {
        this.users = users;
        return this;
    }

    public MockUserStore getUserStore() {
        return this.users;
    }

    public Swift setPublicHost(String publicHost) {
        this.publicHost = publicHost;
        return this;
    }

    public Swift setPrivateHost(String privateHost) {
        this.privateHost = privateHost;
        return this;
    }

    public Swift setMillisDelay(long millisDelay) {
        this.millisDelay = millisDelay;
        return this;
    }

    public Swift setObjectDeleterStartAfterSeconds(int objectDeleterStartAfterSeconds) {
        this.objectDeleterStartAfterSeconds = objectDeleterStartAfterSeconds;
        return this;
    }

    public Swift setObjectDeleterIntervalSeconds(int objectDeleterIntervalSeconds) {
        this.objectDeleterIntervalSeconds = objectDeleterIntervalSeconds;
        return this;
    }

    public Swift setTenantSupplied(String tenantId, String tenantName) {
        this.tenantSupplied = tenantId != null || tenantName != null;
        return this;
    }

    public Swift setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public SwiftResult<Tenants> getTenant() {
        Tenants tenants = new Tenants();
        Tenant tenant = new Tenant();
        tenant.id = "mock-id";
        tenant.name = "mock-name";
        tenant.enabled = true;
        tenants.tenants.add(tenant);
        return new SwiftResult<Tenants>(tenants, 200);
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public void addIgnore() {
        this.statusGenerator.addIgnore();
    }

    public void addIgnore(Class<? extends CommandMock> ignoreClass) {
        this.statusGenerator.addIgnore(ignoreClass);
    }

    public void addStatus(int status) {
        this.statusGenerator.addStatus(status);
    }

    public void addStatus(Class<? extends CommandMock> clazz, int status) {
        this.statusGenerator.addStatus(clazz, status);
    }

    public int getStatus(Class<? extends CommandMock> clazz) {
        return this.statusGenerator.getStatus(clazz);
    }

    public String getHashPassword() {
        Header header = this.headers.get("X-Account-Meta-Temp-Url-Key");
        return header == null ? null : header.getHeaderValue();
    }

    public SwiftResult<Access> authenticate(String tenantName, String tenantId, String username, String password) {
        if (this.users.authenticate(tenantName, tenantId, username, password)) {
            return new SwiftResult<Object>(null, 200);
        }
        return new SwiftResult<Access>(401);
    }

    public SwiftResult<Collection<Container>> listContainers(Account account, ListInstructions listInstructions) {
        Collection<SwiftContainer> pagedContainers = new PageServer<SwiftContainer>().createPage(this.containers.values(), listInstructions.getPrefix(), listInstructions.getMarker(), listInstructions.getLimit());
        ArrayList<Container> containers = new ArrayList<Container>();
        for (SwiftContainer containerHeader : pagedContainers) {
            Container container = account.getContainer(containerHeader.getName());
            container.setCount(containerHeader.getCount());
            container.setBytesUsed(containerHeader.getBytesUsed());
            container.metadataSetFromHeaders();
            containers.add(container);
        }
        return new SwiftResult<Collection<Container>>(containers, 200);
    }

    public String getPublicHost() {
        return this.publicHost == null ? "" : this.publicHost;
    }

    public String getPrivateHost() {
        return this.privateHost == null ? "" : this.privateHost;
    }

    public SwiftResult<AccountInformation> getAccountInformation() {
        AccountInformation accountInformation = new AccountInformation();
        accountInformation.setMetadata(this.headers.getMetadata());
        int containerCount = 0;
        int objectCount = 0;
        long bytesUsed = 0L;
        for (SwiftContainer container : this.containers.values()) {
            ++containerCount;
            objectCount += container.getCount();
            bytesUsed += container.getBytesUsed();
        }
        accountInformation.setContainerCount(new AccountContainerCount(Integer.toString(containerCount)));
        accountInformation.setObjectCount(new AccountObjectCount(Integer.toString(objectCount)));
        accountInformation.setBytesUsed(new AccountBytesUsed(Long.toString(bytesUsed)));
        accountInformation.setServerDate(new ServerDate(LocalTime.currentTime()));
        return new SwiftResult<AccountInformation>(accountInformation, 204);
    }

    public SwiftResult<Object> saveMetadata(Collection<? extends Header> headers) {
        this.headers.saveMetadata(headers);
        return new SwiftResult<Object>(204);
    }

    public SwiftResult<Object> saveHashPassword(String hashPassword) {
        this.headers.put(new HashPassword(hashPassword));
        return new SwiftResult<Object>(204);
    }

    public SwiftContainer getContainer(String name) {
        return this.containers.get(name);
    }

    public SwiftResult<Object> createContainer(String name) {
        if (this.containers.get(name) == null) {
            this.containers.put(name, new SwiftContainer(name));
            return new SwiftResult<Object>(201);
        }
        return new SwiftResult<Object>(202);
    }

    public SwiftResult<String[]> deleteContainer(String name) {
        SwiftContainer container = this.getContainer(name);
        if (container == null) {
            return new SwiftResult<String[]>(404);
        }
        if (container.getCount() > 0) {
            return new SwiftResult<String[]>(409);
        }
        this.containers.remove(name);
        return new SwiftResult<String[]>(new String[0], 204);
    }

    public SwiftResult<ContainerInformation> getContainerInformation(String name) {
        SwiftContainer container = this.getContainer(name);
        if (container == null) {
            return new SwiftResult<ContainerInformation>(404);
        }
        return new SwiftResult<ContainerInformation>(container.getInfo(), 204);
    }

    public SwiftResult<Object> saveContainerMetadata(String name, Collection<? extends Header> headers) {
        SwiftContainer container = this.getContainer(name);
        if (container == null) {
            return new SwiftResult<Object>(404);
        }
        return container.saveMetadata(headers);
    }

    public SwiftResult<String[]> setContainerPrivacy(String name, boolean publicContainer) {
        SwiftContainer container = this.getContainer(name);
        if (container == null) {
            return new SwiftResult<String[]>(404);
        }
        return container.setContainerPrivacy(publicContainer);
    }

    public SwiftResult<Collection<StoredObject>> listObjects(Container container, ListInstructions listInstructions) {
        SwiftContainer swiftContainer = this.getContainer(container.getName());
        if (swiftContainer == null) {
            return new SwiftResult<Collection<StoredObject>>(404);
        }
        return swiftContainer.listObjects(container, listInstructions);
    }

    public SwiftResult<Collection<DirectoryOrObject>> listDirectory(Container container, ListInstructions listInstructions) {
        SwiftContainer swiftContainer = this.getContainer(container.getName());
        if (swiftContainer == null) {
            return new SwiftResult<Collection<DirectoryOrObject>>(404);
        }
        return swiftContainer.listDirectories(container, listInstructions);
    }

    public SwiftResult<Object> uploadObject(Container container, StoredObject object, UploadInstructions uploadInstructions) {
        SwiftContainer foundContainer = this.containers.get(container.getName());
        if (foundContainer == null) {
            return new SwiftResult<Object>(404);
        }
        SwiftStoredObject foundObject = foundContainer.getObject(object.getName());
        if (foundObject == null) {
            foundObject = foundContainer.createObject(object.getName());
        }
        return foundObject.uploadObject(uploadInstructions);
    }

    public SwiftResult<Object> copyObject(Container sourceContainer, StoredObject sourceObject, Container targetContainer, StoredObject targetObject) {
        SwiftContainer foundSourceContainer = this.containers.get(sourceContainer.getName());
        if (foundSourceContainer == null) {
            return new SwiftResult<Object>(404);
        }
        SwiftStoredObject foundSourceObject = foundSourceContainer.getObject(sourceObject.getName());
        if (foundSourceObject == null) {
            return new SwiftResult<Object>(404);
        }
        SwiftContainer foundTargetContainer = this.containers.get(targetContainer.getName());
        if (foundTargetContainer == null) {
            return new SwiftResult<Object>(404);
        }
        SwiftStoredObject foundTargetObject = foundTargetContainer.getObject(targetObject.getName());
        if (foundTargetObject == null) {
            foundTargetObject = foundTargetContainer.createObject(targetObject.getName());
        }
        return foundTargetObject.copyFrom(foundSourceObject);
    }

    public SwiftResult<Object> deleteObject(Container container, StoredObject object) {
        SwiftContainer foundContainer = this.containers.get(container.getName());
        if (foundContainer == null) {
            return new SwiftResult<Object>(404);
        }
        SwiftStoredObject foundObject = foundContainer.getObject(object.getName());
        if (foundObject == null) {
            return new SwiftResult<Object>(404);
        }
        foundContainer.deleteObject(object.getName());
        return new SwiftResult<Object>(204);
    }

    public SwiftResult<Object> saveObjectMetadata(Container container, StoredObject object, Collection<? extends Header> headers) {
        DeleteAfter deleteAfter;
        SwiftContainer foundContainer = this.containers.get(container.getName());
        if (foundContainer == null) {
            return new SwiftResult<Object>(404);
        }
        SwiftStoredObject foundObject = foundContainer.getObject(object.getName());
        if (foundObject == null) {
            return new SwiftResult<Object>(404);
        }
        DeleteAt deleteAt = this.getSpecificHeader(headers, DeleteAt.class);
        if (deleteAt == null && (deleteAfter = this.getSpecificHeader(headers, DeleteAfter.class)) != null) {
            deleteAt = new DeleteAt(new Date(LocalTime.currentTime() + deleteAfter.getExpireAfterSeconds() * 1000L));
        }
        if (deleteAt != null) {
            if (this.allowObjectDeleter) {
                this.getCurrentObjectDeleter().scheduleForDeletion(foundContainer, foundObject, deleteAt.getDate());
                foundObject.setDeleteAt(deleteAt);
            } else {
                foundContainer.deleteObject(foundObject.getName());
            }
        }
        return foundObject.saveMetadata(headers);
    }

    private <T extends Header> T getSpecificHeader(Collection<? extends Header> headers, Class<T> matchClass) {
        for (Header header : headers) {
            if (!matchClass.isInstance(header)) continue;
            return (T)header;
        }
        return null;
    }

    public SwiftResult<ObjectInformation> getObjectInformation(Container container, StoredObject object) {
        SwiftContainer foundContainer = this.containers.get(container.getName());
        if (foundContainer == null) {
            return new SwiftResult<ObjectInformation>(404);
        }
        SwiftStoredObject foundObject = foundContainer.getObject(object.getName());
        if (foundObject == null) {
            return new SwiftResult<ObjectInformation>(404);
        }
        return new SwiftResult<ObjectInformation>(foundObject.getInfo(), 200);
    }

    public SwiftResult<byte[]> downloadObject(Container container, StoredObject object, DownloadInstructions downloadInstructions) {
        SwiftContainer foundContainer = this.containers.get(container.getName());
        if (foundContainer == null) {
            return new SwiftResult<byte[]>(404);
        }
        SwiftStoredObject foundObject = foundContainer.getObject(object.getName());
        if (foundObject == null) {
            return new SwiftResult<byte[]>(404);
        }
        ObjectManifest objectManifest = foundObject.getObjectManifest();
        if (objectManifest != null) {
            return new SwiftResult<byte[]>(this.mergeSegmentedObjects(objectManifest), 200);
        }
        return foundObject.downloadObject(downloadInstructions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwiftResult<Object> downloadObject(Container container, StoredObject object, File targetFile, DownloadInstructions downloadInstructions) {
        ByteArrayInputStream is = null;
        FileOutputStream os = null;
        try {
            SwiftResult<byte[]> byteArray = this.downloadObject(container, object, downloadInstructions);
            if (byteArray.getPayload() == null) {
                SwiftResult<Object> swiftResult = new SwiftResult<Object>(byteArray.getStatus());
                this.closeStreams(is, os);
                return swiftResult;
            }
            is = new ByteArrayInputStream(byteArray.getPayload());
            os = new FileOutputStream(targetFile);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            this.closeStreams(is, os);
        }
        catch (IOException err) {
            SwiftResult<Object> swiftResult = new SwiftResult<Object>(422);
            return swiftResult;
        }
        finally {
            this.closeStreams(is, os);
        }
        return new SwiftResult<Object>(200);
    }

    protected void closeStreams(InputStream is, OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public SwiftResult<InputStream> downloadObjectAsInputStream(Container container, StoredObject object, DownloadInstructions downloadInstructions) {
        SwiftResult<byte[]> byteArray = this.downloadObject(container, object, downloadInstructions);
        if (byteArray.getPayload() == null) {
            return new SwiftResult<InputStream>(byteArray.getStatus());
        }
        return new SwiftResult<InputStream>(new MockInputStreamWrapper(new ByteArrayInputStream(byteArray.getPayload())), 200);
    }

    protected byte[] mergeSegmentedObjects(ObjectManifest objectManifest) {
        SwiftContainer segmentFolder = this.getContainer(objectManifest.getContainerName());
        String objectPrefix = objectManifest.getObjectPrefix();
        ArrayList<SwiftStoredObject> segments = new ArrayList<SwiftStoredObject>();
        int byteCount = 0;
        for (SwiftStoredObject storedObject : segmentFolder.getAllObjects()) {
            if (!storedObject.getName().startsWith(objectPrefix) || storedObject.getName().equals(objectPrefix)) continue;
            segments.add(storedObject);
            byteCount = (int)((long)byteCount + storedObject.getBytesUsed());
        }
        byte[] mergedObject = new byte[byteCount];
        int offset = 0;
        for (SwiftStoredObject segment : segments) {
            System.arraycopy(segment.getContent(), 0, mergedObject, offset, (int)segment.getBytesUsed());
            offset = (int)((long)offset + segment.getBytesUsed());
        }
        return mergedObject;
    }

    public long getMillisDelay() {
        return this.millisDelay;
    }

    public boolean isTenantSupplied() {
        return this.tenantSupplied;
    }
}

