/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.headers.object.conditional;

import java.util.Date;
import org.apache.http.impl.cookie.DateParseException;
import org.javaswift.joss.exception.HttpStatusExceptionUtil;
import org.javaswift.joss.headers.object.conditional.AbstractIfSince;

public class IfModifiedSince
extends AbstractIfSince {
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";

    public IfModifiedSince(Long milliseconds) {
        super(milliseconds);
    }

    public IfModifiedSince(String sinceDate) throws DateParseException {
        super(sinceDate);
    }

    public IfModifiedSince(Date date) {
        super(date);
    }

    @Override
    public void sinceAgainst(Date modificationDate) {
        if (this.getDate().getTime() / 1000L >= modificationDate.getTime() / 1000L) {
            HttpStatusExceptionUtil.throwException(304);
        }
    }

    @Override
    public String getHeaderName() {
        return IF_MODIFIED_SINCE;
    }
}

