/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.shared.identity.access;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonRootName;
import org.javaswift.joss.client.factory.TempUrlHashPrefixSource;
import org.javaswift.joss.command.shared.identity.access.AbstractAccess;
import org.javaswift.joss.command.shared.identity.access.EndPoint;
import org.javaswift.joss.command.shared.identity.access.ServiceCatalog;
import org.javaswift.joss.exception.CommandExceptionError;
import org.javaswift.joss.exception.HttpStatusExceptionUtil;

@JsonRootName(value="access")
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessTenant
extends AbstractAccess {
    public List<ServiceCatalog> serviceCatalog = new ArrayList<ServiceCatalog>();
    @JsonIgnore
    private EndPoint currentEndPoint;

    private ServiceCatalog getObjectStoreCatalog() {
        for (ServiceCatalog catalog : this.serviceCatalog) {
            if (!"object-store".equals(catalog.type)) continue;
            return catalog;
        }
        return null;
    }

    @Override
    public boolean isTenantSupplied() {
        return true;
    }

    @Override
    public String getTempUrlPrefix(TempUrlHashPrefixSource tempUrlHashPrefixSource) {
        String tempUrlPrefix = tempUrlHashPrefixSource == null ? "" : (tempUrlHashPrefixSource == TempUrlHashPrefixSource.PUBLIC_URL_PATH ? TempUrlHashPrefixSource.getPath(this.getCurrentEndPoint().publicURL) : (tempUrlHashPrefixSource == TempUrlHashPrefixSource.INTERNAL_URL_PATH ? TempUrlHashPrefixSource.getPath(this.getCurrentEndPoint().internalURL) : TempUrlHashPrefixSource.getPath(this.getCurrentEndPoint().adminURL)));
        return tempUrlPrefix.endsWith("/") ? tempUrlPrefix.substring(0, tempUrlPrefix.length() - 1) : tempUrlPrefix;
    }

    @Override
    protected EndPoint determineCurrentEndPoint() {
        if (this.currentEndPoint != null) {
            return this.currentEndPoint;
        }
        ServiceCatalog objectStoreCatalog = this.getObjectStoreCatalog();
        if (objectStoreCatalog == null) {
            HttpStatusExceptionUtil.throwException(404, CommandExceptionError.NO_SERVICE_CATALOG_FOUND);
        }
        this.currentEndPoint = objectStoreCatalog.getRegion(this.getPreferredRegion());
        if (this.currentEndPoint == null) {
            HttpStatusExceptionUtil.throwException(404, CommandExceptionError.NO_END_POINT_FOUND);
        }
        return this.currentEndPoint;
    }
}

