/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.shared.identity.access;

import org.javaswift.joss.command.shared.identity.access.EndPoint;
import org.javaswift.joss.command.shared.identity.access.Metadata;
import org.javaswift.joss.command.shared.identity.access.Token;
import org.javaswift.joss.command.shared.identity.access.User;
import org.javaswift.joss.exception.CommandExceptionError;
import org.javaswift.joss.exception.HttpStatusExceptionUtil;
import org.javaswift.joss.model.Access;

public abstract class AbstractAccess
implements Access {
    public static final String SERVICE_CATALOG_OBJECT_STORE = "object-store";
    public Token token;
    public User user;
    public Metadata metadata;
    private String preferredRegion;

    protected abstract EndPoint determineCurrentEndPoint();

    @Override
    public abstract boolean isTenantSupplied();

    @Override
    public String getToken() {
        return this.token == null ? null : this.token.id;
    }

    public String getPreferredRegion() {
        return this.preferredRegion;
    }

    @Override
    public void setPreferredRegion(String preferredRegion) {
        this.preferredRegion = preferredRegion;
    }

    protected EndPoint getCurrentEndPoint() {
        if (!this.isTenantSupplied()) {
            HttpStatusExceptionUtil.throwException(404, CommandExceptionError.NO_TENANT_SUPPLIED);
        }
        return this.determineCurrentEndPoint();
    }

    @Override
    public String getInternalURL() {
        return this.getCurrentEndPoint().internalURL;
    }

    @Override
    public String getPublicURL() {
        return this.getCurrentEndPoint().publicURL;
    }
}

