/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.impl.object;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusChecker;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusFailCondition;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusMatch;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusSuccessCondition;
import org.javaswift.joss.command.impl.object.AbstractObjectCommand;
import org.javaswift.joss.exception.HttpStatusExceptionUtil;
import org.javaswift.joss.headers.Header;
import org.javaswift.joss.headers.object.ObjectManifest;
import org.javaswift.joss.instructions.DownloadInstructions;
import org.javaswift.joss.model.Access;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.StoredObject;

public abstract class AbstractDownloadObjectCommand<M extends HttpGet, N>
extends AbstractObjectCommand<HttpGet, N> {
    public static final String ETAG = "ETag";
    public static final String CONTENT_LENGTH = "Content-Length";

    public AbstractDownloadObjectCommand(Account account, HttpClient httpClient, Access access, StoredObject object, DownloadInstructions downloadInstructions) {
        super(account, httpClient, access, object);
        this.processDownloadInstructions(downloadInstructions);
    }

    private void processDownloadInstructions(DownloadInstructions downloadInstructions) {
        this.setHeader(downloadInstructions.getRange());
        this.setHeader(downloadInstructions.getMatchConditional());
        this.setHeader(downloadInstructions.getSinceConditional());
        if (downloadInstructions.getHeaders() != null) {
            for (Header header : downloadInstructions.getHeaders().values()) {
                this.setHeader(header);
            }
        }
    }

    @Override
    protected N getReturnObject(HttpResponse response) throws IOException {
        String realMd5;
        String expectedMd5 = response.getHeaders(ETAG)[0].getValue().replaceAll("\"", "");
        boolean isManifest = Header.headerNotEmpty(response, ObjectManifest.X_OBJECT_MANIFEST);
        this.handleEntity(response.getEntity());
        if (!isManifest && 206 != response.getStatusLine().getStatusCode() && (realMd5 = this.getMd5()) != null && !expectedMd5.equals(realMd5)) {
            HttpStatusExceptionUtil.throwException(422);
        }
        return this.getObjectAsReturnObject();
    }

    protected abstract void handleEntity(HttpEntity var1) throws IOException;

    protected abstract String getMd5() throws IOException;

    protected abstract N getObjectAsReturnObject();

    @Override
    protected HttpGet createRequest(String url) {
        return new HttpGet(url);
    }

    @Override
    public HttpStatusChecker[] getStatusCheckers() {
        return new HttpStatusChecker[]{new HttpStatusSuccessCondition(new HttpStatusMatch(200)), new HttpStatusSuccessCondition(new HttpStatusMatch(206)), new HttpStatusFailCondition(new HttpStatusMatch(404)), new HttpStatusFailCondition(new HttpStatusMatch(304)), new HttpStatusFailCondition(new HttpStatusMatch(412))};
    }
}

