/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.website;

import java.io.File;
import org.javaswift.joss.client.website.AbstractFileObjects;
import org.javaswift.joss.client.website.LocalFileObject;
import org.javaswift.joss.util.FileAction;
import org.javaswift.joss.util.FileReference;

public class LocalFileObjects
extends AbstractFileObjects {
    private final File rootDirectory;

    public LocalFileObjects(File rootDirectory, String[] ignoreFilters) {
        super(ignoreFilters);
        this.rootDirectory = rootDirectory;
        for (FileReference file : FileAction.listFiles(this.rootDirectory, ignoreFilters)) {
            this.add(file.getPath(), new LocalFileObject(file));
        }
    }

    @Override
    public LocalFileObject create(String path) {
        FileReference fileReference = new FileReference(new File(this.rootDirectory.getPath() + "/" + path), null);
        if (path.lastIndexOf("/") > -1) {
            String pathExcludingFile = path.substring(0, path.lastIndexOf("/"));
            new File(this.rootDirectory.getPath() + "/" + pathExcludingFile).mkdirs();
        }
        return new LocalFileObject(fileReference);
    }

    @Override
    public void cleanup() {
        this.deleteEmptyDirectories(this.rootDirectory);
    }

    protected void deleteEmptyDirectories(File directory) {
        for (File file : directory.listFiles()) {
            if (!file.isDirectory()) continue;
            this.deleteEmptyDirectories(file);
            file.delete();
        }
    }
}

