/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.website;

import java.io.File;
import org.javaswift.joss.client.core.AbstractContainer;
import org.javaswift.joss.client.website.FileObject;
import org.javaswift.joss.client.website.FileObjects;
import org.javaswift.joss.client.website.LocalFileObjects;
import org.javaswift.joss.client.website.ObjectStoreFileObjects;
import org.javaswift.joss.headers.website.ErrorPage;
import org.javaswift.joss.headers.website.IndexPage;
import org.javaswift.joss.headers.website.Listing;
import org.javaswift.joss.headers.website.ListingCSS;
import org.javaswift.joss.headers.website.WebsiteHeader;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.StoredObject;
import org.javaswift.joss.model.Website;

public abstract class AbstractWebsite
extends AbstractContainer
implements Website {
    private String[] ignoreFilters = new String[0];

    public AbstractWebsite(Account account, String name, boolean allowCaching) {
        super(account, name, allowCaching);
    }

    @Override
    public Website setIgnoreFilters(String[] ignoreFilters) {
        this.ignoreFilters = ignoreFilters;
        return this;
    }

    @Override
    public Website create() {
        super.create();
        this.makePublic();
        return this;
    }

    protected Object getHeader(String metadataHeaderName) {
        return this.getMetadata(metadataHeaderName);
    }

    protected StoredObject getStoredObject(String metadataHeaderName) {
        Object value = this.getHeader(metadataHeaderName);
        return value != null ? this.getObject(value.toString()) : null;
    }

    protected void setHeader(WebsiteHeader header) {
        this.setAndSaveMetadata(header.getMetadataHeader(), header.getHeaderValue());
    }

    public String getMetadataHeader(String websiteHeader) {
        return "Web-" + websiteHeader;
    }

    @Override
    public StoredObject getIndexPage() {
        return this.getStoredObject(this.getMetadataHeader("Index"));
    }

    @Override
    public StoredObject getErrorPage() {
        return this.getStoredObject(this.getMetadataHeader("Error"));
    }

    @Override
    public StoredObject getListingCSS() {
        return this.getStoredObject(this.getMetadataHeader("Listing-CSS"));
    }

    @Override
    public boolean isListing() {
        Object value = this.getHeader(this.getMetadataHeader("Listing"));
        return value != null && Boolean.parseBoolean(value.toString());
    }

    @Override
    public void setIndexPage(StoredObject indexPage) {
        this.setHeader(new IndexPage(indexPage.getName()));
    }

    @Override
    public void setErrorPage(StoredObject errorPage) {
        this.setHeader(new ErrorPage(errorPage.getName()));
    }

    @Override
    public void setListingCSS(StoredObject listingCSS) {
        this.setHeader(new ListingCSS(listingCSS.getName()));
    }

    @Override
    public void setListing(boolean listing) {
        this.setHeader(new Listing(listing));
    }

    @Override
    public void pushDirectory(File directory) {
        this.syncDirectory(new LocalFileObjects(directory, this.ignoreFilters), new ObjectStoreFileObjects(this));
    }

    @Override
    public void pullDirectory(File directory) {
        this.syncDirectory(new ObjectStoreFileObjects(this), new LocalFileObjects(directory, this.ignoreFilters));
    }

    protected void syncDirectory(FileObjects source, FileObjects target) {
        this.saveObjects(source, target);
        this.deleteObjects(source, target);
        target.cleanup();
    }

    private void deleteObjects(FileObjects source, FileObjects target) {
        for (String targetPath : target.keys()) {
            if (target.ignore(targetPath)) continue;
            FileObject targetObject = target.get(targetPath);
            if (source.get(targetPath) != null) continue;
            targetObject.delete();
        }
    }

    private void saveObjects(FileObjects source, FileObjects target) {
        for (String sourcePath : source.keys()) {
            FileObject sourceObject = source.get(sourcePath);
            FileObject targetObject = target.get(sourcePath);
            if (targetObject == null) {
                targetObject = target.create(sourcePath);
            } else if (sourceObject.getMd5().equals(targetObject.getMd5())) continue;
            targetObject.save(sourceObject);
        }
    }

    @Override
    public String getHost() {
        String strippedHost = this.getAccount().getOriginalHost().replaceAll("http://", "").replaceAll("https://", "");
        return this.getName() + "." + strippedHost;
    }
}

