/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.impl;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfigurer {
    public static final Logger LOG = LoggerFactory.getLogger(ProxyConfigurer.class);
    private final String host;
    private final int port;
    private final String username;
    private final String password;

    public ProxyConfigurer(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        LOG.info("JOSS / Use proxy: " + host + ":" + port);
    }

    public boolean hasHostAndPort() {
        return this.host != null && this.port > 0;
    }

    public void configureHttpClientBuilder(HttpClientBuilder clientBuilder) {
        try {
            if (this.mustAuthorize()) {
                LOG.info("JOSS / Proxy with authorization: " + this.username + " \\ *********");
                clientBuilder.setDefaultCredentialsProvider(this.createCredentialsProvider());
            }
            clientBuilder.setProxy(this.createProxy());
        }
        catch (Exception e) {
            LOG.error("JOSS / Invalid proxy authorization settings");
        }
    }

    private HttpHost createProxy() {
        return new HttpHost(this.host, this.port, this.getHttpScheme());
    }

    private boolean mustAuthorize() {
        return this.username != null && this.password != null;
    }

    private CredentialsProvider createCredentialsProvider() {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(this.host, this.port), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        return credsProvider;
    }

    private String getHttpScheme() {
        return this.host.startsWith("https") ? "https" : "http";
    }
}

