/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.javaswift.joss.client.core.AbstractAccount;
import org.javaswift.joss.client.core.AbstractObjectStoreEntity;
import org.javaswift.joss.client.core.ContainerDirectoryPaginationMap;
import org.javaswift.joss.client.core.ContainerPaginationMap;
import org.javaswift.joss.command.shared.factory.ContainerCommandFactory;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.headers.Header;
import org.javaswift.joss.headers.Metadata;
import org.javaswift.joss.headers.container.ContainerBytesUsed;
import org.javaswift.joss.headers.container.ContainerMetadata;
import org.javaswift.joss.headers.container.ContainerObjectCount;
import org.javaswift.joss.information.AbstractInformation;
import org.javaswift.joss.information.ContainerInformation;
import org.javaswift.joss.instructions.ListInstructions;
import org.javaswift.joss.instructions.SegmentationPlan;
import org.javaswift.joss.instructions.UploadInstructions;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.Container;
import org.javaswift.joss.model.Directory;
import org.javaswift.joss.model.DirectoryOrObject;
import org.javaswift.joss.model.FormPost;
import org.javaswift.joss.model.PaginationMap;
import org.javaswift.joss.model.StoredObject;
import org.javaswift.joss.util.HashSignature;
import org.javaswift.joss.util.SpaceURLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContainer
extends AbstractObjectStoreEntity<ContainerInformation>
implements Container {
    public static final Logger LOG = LoggerFactory.getLogger(UploadInstructions.class);
    private static final Integer MAX_PAGE_SIZE = 9999;
    protected final String name;
    private final Account account;
    private final ContainerCommandFactory commandFactory;
    private Collection<Header> customHeaders;

    public AbstractContainer(Account account, String name, boolean allowCaching) {
        super(allowCaching);
        this.commandFactory = ((AbstractAccount)account).getFactory().getContainerCommandFactory();
        this.name = name;
        this.account = account;
        this.info = new ContainerInformation();
    }

    @Override
    public Collection<StoredObject> list() {
        return new ContainerPaginationMap(this, null, MAX_PAGE_SIZE).listAllItems();
    }

    @Override
    public Collection<StoredObject> list(PaginationMap paginationMap, int page) {
        return this.list(paginationMap.getPrefix(), paginationMap.getMarker(page), paginationMap.getPageSize());
    }

    @Override
    public Collection<StoredObject> list(String prefix, String marker, int pageSize) {
        ListInstructions listInstructions = new ListInstructions().setPrefix(prefix).setMarker(marker).setLimit(pageSize);
        return (Collection)this.commandFactory.createListObjectsCommand(this.getAccount(), this, listInstructions).call();
    }

    @Override
    public Collection<DirectoryOrObject> listDirectory(String prefix, Character delimiter, String marker, int pageSize) {
        ListInstructions listInstructions = new ListInstructions().setPrefix(prefix).setDelimiter(delimiter).setMarker(marker).setLimit(pageSize);
        return (Collection)this.commandFactory.createListDirectoryCommand(this.getAccount(), this, listInstructions, this.commandFactory.getDelimiter()).call();
    }

    @Override
    public Collection<DirectoryOrObject> listDirectory(Directory directory) {
        return new ContainerDirectoryPaginationMap(this, this.commandFactory.getDelimiter(), directory == null ? null : directory.getName(), MAX_PAGE_SIZE).listAllItems();
    }

    @Override
    public Collection<DirectoryOrObject> listDirectory() {
        return this.listDirectory(null);
    }

    @Override
    public void metadataSetFromHeaders() {
        this.staleHeaders = false;
    }

    @Override
    public PaginationMap getPaginationMap(String prefix, int pageSize) {
        return new ContainerPaginationMap(this, prefix, (Integer)pageSize).buildMap();
    }

    @Override
    public PaginationMap getPaginationMap(int pageSize) {
        return this.getPaginationMap(null, pageSize);
    }

    @Override
    public StoredObject getObjectSegment(String name, int part) {
        return this.getObject(name + "/" + String.format("%08d", part));
    }

    @Override
    public int getCount() {
        this.checkForInfoAndAllowHeaderSet();
        return ((ContainerInformation)this.info).getObjectCount();
    }

    @Override
    public long getBytesUsed() {
        this.checkForInfoAndAllowHeaderSet();
        return ((ContainerInformation)this.info).getBytesUsed();
    }

    @Override
    public FormPost getFormPost(String redirect, long maxFileSize, long maxFileCount, long seconds) {
        String path = this.commandFactory.getTempUrlPrefix() + this.getPath();
        long expires = this.getAccount().getActualServerTimeInSeconds(seconds);
        String plainText = path + "\n" + redirect + "\n" + maxFileSize + "\n" + maxFileCount + "\n" + expires;
        FormPost formPost = new FormPost();
        formPost.setExpires(expires);
        formPost.setSignature(HashSignature.getSignature(this.getAccount().getHashPassword(), plainText));
        return formPost;
    }

    @Override
    public void setCount(int count) {
        ((ContainerInformation)this.info).setObjectCount(new ContainerObjectCount(Integer.toString(count)));
    }

    @Override
    public void setBytesUsed(long bytesUsed) {
        ((ContainerInformation)this.info).setBytesUsed(new ContainerBytesUsed(Long.toString(bytesUsed)));
    }

    @Override
    public boolean isPublic() {
        this.checkForInfo();
        return ((ContainerInformation)this.info).isPublicContainer();
    }

    @Override
    public String getContainerReadPermission() {
        this.checkForInfo();
        return ((ContainerInformation)this.info).getReadPermissions();
    }

    @Override
    public String getcontainerWritePermission() {
        this.checkForInfo();
        return ((ContainerInformation)this.info).getWritePermissions();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Account getAccount() {
        return this.account;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Container && this.getName().equals(((Container)o).getName());
    }

    @Override
    public int compareTo(Container o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    protected Metadata createMetadataEntry(String name, String value) {
        return new ContainerMetadata(name, value);
    }

    public void uploadSegmentedObjects(String name, UploadInstructions uploadInstructions) {
        String path = this.getName() + "/" + name;
        try {
            LOG.info("JOSS / Setting up a segmentation plan for " + path);
            SegmentationPlan plan = uploadInstructions.getSegmentationPlan();
            InputStream segmentStream = plan.getNextSegment();
            while (segmentStream != null) {
                LOG.info("JOSS / Uploading segment " + plan.getSegmentNumber());
                StoredObject segment = this.getObjectSegment(name, plan.getSegmentNumber().intValue());
                segment.uploadObject(segmentStream);
                segmentStream.close();
                segmentStream = plan.getNextSegment();
            }
        }
        catch (IOException err) {
            LOG.error("JOSS / Failed to set up a segmentation plan for " + path + ": " + err.getMessage());
            throw new CommandException("Unable to upload segments", err);
        }
    }

    @Override
    public int getMaxPageSize() {
        return MAX_PAGE_SIZE;
    }

    public ContainerCommandFactory getFactory() {
        return this.commandFactory;
    }

    @Override
    public void makePublic() {
        this.setContainerRights(true);
    }

    @Override
    public void makePrivate() {
        this.setContainerRights(false);
    }

    public void setContainerRights(boolean publicContainer) {
        this.commandFactory.createContainerRightsCommand(this.getAccount(), this, publicContainer).call();
        ((ContainerInformation)this.info).setPublicContainer(publicContainer);
    }

    @Override
    public void setContainerRights(String writePermissions, String readPermissions) {
        this.commandFactory.createContainerRightsCommand(this.getAccount(), this, writePermissions, readPermissions).call();
        ((ContainerInformation)this.info).setWritePermissions(writePermissions);
        ((ContainerInformation)this.info).setReadPermissions(readPermissions);
    }

    @Override
    public Container create() {
        this.commandFactory.createCreateContainerCommand(this.getAccount(), this).call();
        return this;
    }

    @Override
    public void delete() {
        this.commandFactory.createDeleteContainerCommand(this.getAccount(), this).call();
    }

    @Override
    protected void saveSpecificMetadata() {
        this.commandFactory.createContainerMetadataCommand(this.getAccount(), this, ((ContainerInformation)this.info).getMetadata()).call();
    }

    @Override
    protected void getInfo(boolean allowErrorLog) {
        this.info = (AbstractInformation)this.commandFactory.createContainerInformationCommand(this.getAccount(), this, allowErrorLog).call();
        this.setInfoRetrieved();
    }

    @Override
    public String getPathForEntity() throws UnsupportedEncodingException {
        return "/" + SpaceURLEncoder.encode(this.getName());
    }

    @Override
    public void setCustomHeaders(Collection<Header> headers) {
        this.customHeaders = headers;
    }

    @Override
    public Collection<Header> getCustomHeaders() {
        return this.customHeaders;
    }
}

