/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.core;

import org.javaswift.joss.client.factory.AccountConfig;
import org.javaswift.joss.command.shared.factory.AuthenticationCommandFactory;
import org.javaswift.joss.command.shared.identity.tenant.Tenant;
import org.javaswift.joss.command.shared.identity.tenant.Tenants;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient<A extends Account>
implements Client<A> {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractClient.class);
    protected AccountConfig accountConfig;
    protected AuthenticationCommandFactory factory;

    public AbstractClient(AccountConfig accountConfig) {
        this.accountConfig = accountConfig;
        this.logSettings();
        this.factory = this.createFactory();
    }

    protected abstract void logSettings();

    protected abstract AuthenticationCommandFactory createFactory();

    protected abstract A createAccount();

    @Override
    public A authenticate() {
        A account = this.createAccount();
        if (!account.isTenantSupplied()) {
            Tenant tenant = this.autoDiscoverTenant((Account)account);
            this.accountConfig.setTenantId(tenant.id);
            this.accountConfig.setTenantName(tenant.name);
            account = this.createAccount();
        }
        if (this.accountConfig.isAllowSynchronizeWithServer()) {
            account.synchronizeWithServerTime();
        }
        return (A)account.setPublicHost(this.accountConfig.getPublicHost()).setPrivateHost(this.accountConfig.getPrivateHost()).setAllowContainerCaching(this.accountConfig.isAllowContainerCaching()).setAllowReauthenticate(this.accountConfig.isAllowReauthenticate()).setHashPassword(this.accountConfig.getHashPassword()).setPreferredRegion(this.accountConfig.getPreferredRegion());
    }

    protected Tenant autoDiscoverTenant(Account account) {
        LOG.warn("JOSS / No tenant supplied, attempting auto-discovery");
        Tenants tenants = account.getTenants();
        Tenant tenant = tenants.getTenant();
        LOG.warn("JOSS / Found tenant with name " + tenant.name + " and ID " + tenant.id);
        return tenant;
    }
}

