/*
 * Decompiled with CFR 0.152.
 */
package org.javastack.surbl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SURBL {
    private static final Logger log = Logger.getLogger(SURBL.class);
    private static final String TWO_LEVEL_TLDS = "http://www.surbl.org/tld/two-level-tlds";
    private static final String THREE_LEVEL_TLDS = "http://www.surbl.org/tld/three-level-tlds";
    private final File storeDir;
    private final File storeLevel2;
    private final File storeLevel3;
    private volatile Set<String> set2 = null;
    private volatile Set<String> set3 = null;
    private int connectionTimeout = 30000;
    private int readTimeout = 60000;

    public SURBL() throws IOException {
        this(System.getProperty("java.io.tmpdir", "/tmp/"));
    }

    public SURBL(String storeDirName) throws IOException {
        this.storeDir = new File(storeDirName);
        if (!this.storeDir.exists() && !this.storeDir.mkdirs()) {
            throw new IOException("Invalid storeDir: " + storeDirName);
        }
        this.storeLevel2 = new File(this.storeDir, "tlds.2");
        this.storeLevel3 = new File(this.storeDir, "tlds.3");
    }

    public SURBL setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public SURBL setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public boolean load() throws IOException {
        long now = System.currentTimeMillis();
        long expire = 86400000L;
        boolean reload = false;
        if (this.storeLevel2.lastModified() + 86400000L < now) {
            this.getTLDS(TWO_LEVEL_TLDS, this.storeLevel2);
            this.loadL2();
            reload = true;
        } else if (this.set2 == null) {
            this.loadL2();
            reload = true;
        }
        if (this.storeLevel3.lastModified() + 86400000L < now) {
            this.getTLDS(THREE_LEVEL_TLDS, this.storeLevel3);
            this.loadL3();
            reload = true;
        } else if (this.set3 == null) {
            this.loadL3();
            reload = true;
        }
        return reload;
    }

    private void loadL2() throws IOException {
        this.set2 = Collections.unmodifiableSet(SURBL.loadSetFromFile(this.storeLevel2, new HashSet<String>(8192)));
    }

    private void loadL3() throws IOException {
        this.set3 = Collections.unmodifiableSet(SURBL.loadSetFromFile(this.storeLevel3, new HashSet<String>(4096)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> loadSetFromFile(File f, Set<String> s) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = reader.readLine()) != null) {
                s.add(line);
            }
            log.info((Object)("Loaded " + s.size() + " TLDs from " + f.getName()));
        }
        catch (Throwable throwable) {
            SURBL.closeSilent(reader);
            throw throwable;
        }
        SURBL.closeSilent(reader);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTLDS(String inputUrl, File cacheFile) throws IOException {
        URL url = new URL(inputUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(this.connectionTimeout);
        conn.setReadTimeout(this.readTimeout);
        conn.setDoOutput(false);
        conn.setUseCaches(true);
        conn.setIfModifiedSince(cacheFile.lastModified());
        conn.connect();
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = conn.getInputStream();
            if (conn.getResponseCode() == 200) {
                os = new FileOutputStream(cacheFile, false);
                byte[] buf = new byte[4096];
                int len = 0;
                while ((len = is.read(buf)) > 0) {
                    ((OutputStream)os).write(buf, 0, len);
                }
                log.info((Object)("HTTP_OK: " + inputUrl));
            } else if (conn.getResponseCode() == 304) {
                log.info((Object)("HTTP_NOT_MODIFIED: " + inputUrl));
            }
        }
        catch (Throwable throwable) {
            SURBL.closeSilent(is);
            SURBL.closeSilent(os);
            throw throwable;
        }
        SURBL.closeSilent(is);
        SURBL.closeSilent(os);
    }

    public boolean checkSURBL(String hostname) throws MalformedURLException {
        String domCheck;
        StringBuilder sb = new StringBuilder(hostname.length() + 16);
        StringTokenizer st = new StringTokenizer(hostname, ".");
        ArrayList<String> list = new ArrayList<String>();
        int levels = 2;
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        try {
            InetAddress inetAddr = InetAddress.getByName(hostname);
            String addr = inetAddr.getHostAddress();
            if (addr.equals(hostname)) {
                if (inetAddr instanceof Inet4Address) {
                    Collections.reverse(list);
                    levels = 4;
                } else if (inetAddr instanceof Inet6Address) {
                    throw new MalformedURLException("Unsupported IPv6");
                }
            }
        }
        catch (UnknownHostException e) {
            log.warn((Object)("UnknownHostException: " + hostname));
        }
        log.info((Object)("Domain tokens: " + list));
        if (list.size() < 2) {
            return false;
        }
        while (true) {
            sb.setLength(0);
            SURBL.getHostLevel(list, levels, sb);
            domCheck = sb.toString();
            if (levels == 2) {
                if (!this.set2.contains(domCheck)) break;
                ++levels;
                continue;
            }
            if (levels != 3 || !this.set3.contains(domCheck)) break;
            ++levels;
        }
        try {
            log.info((Object)("Checking SURBL(levels=" + levels + "): " + domCheck));
            if (InetAddress.getByName(sb.append(".multi.surbl.org.").toString()).getHostAddress().startsWith("127.")) {
                log.info((Object)("SURBL checking (BANNED): " + domCheck));
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        log.info((Object)("SURBL checking (CLEAN): " + domCheck));
        return false;
    }

    private static void getHostLevel(List<String> tokens, int levels, StringBuilder sb) {
        int count = tokens.size();
        int offset = count - levels;
        for (int i = 0; i < levels; ++i) {
            sb.append(tokens.get(offset + i)).append('.');
        }
        sb.setLength(sb.length() - 1);
    }

    private static final void closeSilent(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

