/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.declarations.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.InferenceContext;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedTypeVariable;

public class MethodDeclarationCommonLogic {
    private ResolvedMethodDeclaration methodDeclaration;
    private TypeSolver typeSolver;

    public MethodDeclarationCommonLogic(ResolvedMethodDeclaration methodDeclaration, TypeSolver typeSolver) {
        this.methodDeclaration = methodDeclaration;
        this.typeSolver = typeSolver;
    }

    public MethodUsage resolveTypeVariables(Context context, List<ResolvedType> parameterTypes) {
        ResolvedType returnType = this.replaceTypeParams(this.methodDeclaration.getReturnType(), context);
        ArrayList<ResolvedType> params = new ArrayList<ResolvedType>();
        for (int i = 0; i < this.methodDeclaration.getNumberOfParams(); ++i) {
            ResolvedType replaced = this.replaceTypeParams(this.methodDeclaration.getParam(i).getType(), context);
            params.add(replaced);
        }
        InferenceContext inferenceContext = new InferenceContext(this.typeSolver);
        for (int i = 0; i < this.methodDeclaration.getNumberOfParams(); ++i) {
            ResolvedParameterDeclaration formalParamDecl = this.methodDeclaration.getParam(i);
            ResolvedType formalParamType = formalParamDecl.getType();
            if (formalParamDecl.isVariadic() && parameterTypes.size() < this.methodDeclaration.getNumberOfParams()) break;
            ResolvedType actualParamType = parameterTypes.get(i);
            if (formalParamDecl.isVariadic() && !actualParamType.isArray()) {
                formalParamType = formalParamType.asArrayType().getComponentType();
            }
            inferenceContext.addPair(formalParamType, actualParamType);
        }
        returnType = inferenceContext.resolve(inferenceContext.addSingle(returnType));
        return new MethodUsage(this.methodDeclaration, params, returnType);
    }

    private ResolvedType replaceTypeParams(ResolvedType type, Context context) {
        Optional<ResolvedType> typeParam;
        ResolvedTypeParameterDeclaration typeParameter;
        if (type.isTypeVariable() && (typeParameter = type.asTypeParameter()).declaredOnType() && (typeParam = this.typeParamByName(typeParameter.getName(), context)).isPresent()) {
            type = typeParam.get();
        }
        if (type.isReferenceType()) {
            type.asReferenceType().transformTypeParameters(tp -> this.replaceTypeParams(tp, context));
        }
        return type;
    }

    protected Optional<ResolvedType> typeParamByName(String name, Context context) {
        return this.methodDeclaration.getTypeParameters().stream().filter(tp -> tp.getName().equals(name)).map(tp -> this.toType((ResolvedTypeParameterDeclaration)tp)).findFirst();
    }

    protected ResolvedType toType(ResolvedTypeParameterDeclaration typeParameterDeclaration) {
        return new ResolvedTypeVariable(typeParameterDeclaration);
    }
}

