/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.validation.ValidatorAdapter;

public class RegexpValidator
extends ValidatorAdapter {
    private String rule;
    private String attribute;

    public RegexpValidator(String attribute, String rule) {
        this.rule = rule;
        this.attribute = attribute;
        this.setMessage("value does not match given format");
    }

    public void validate(Model m) {
        if (m.get(this.attribute) == null) {
            m.addValidator(this, this.attribute);
            return;
        }
        Object value = m.get(this.attribute);
        if (!value.getClass().equals(String.class)) {
            throw new IllegalArgumentException("attribute " + this.attribute + " is not String");
        }
        Pattern pattern = Pattern.compile(this.rule, 2);
        Matcher matcher = pattern.matcher(value.toString());
        if (!matcher.matches()) {
            m.addValidator(this, this.attribute);
        }
    }
}

