/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.sql.Timestamp;
import java.util.List;
import org.javalite.activejdbc.Association;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.cache.QueryCache;

class ModelDelegate {
    ModelDelegate() {
    }

    static int update(MetaModel metaModel, String updates, String conditions, Object ... params) {
        Object[] allParams;
        if (metaModel.hasAttribute("updated_at")) {
            updates = "updated_at = ?, " + updates;
            allParams = new Object[params.length + 1];
            System.arraycopy(params, 0, allParams, 1, params.length);
            allParams[0] = new Timestamp(System.currentTimeMillis());
        } else {
            allParams = params;
        }
        String sql = "UPDATE " + metaModel.getTableName() + " SET " + updates + (conditions != null ? " WHERE " + conditions : "");
        int count = new DB(metaModel.getDbName()).exec(sql, allParams);
        if (metaModel.cached()) {
            QueryCache.instance().purgeTableCache(metaModel.getTableName());
        }
        return count;
    }

    static String[] toLowerCase(String[] arr) {
        String[] newArr = new String[arr.length];
        for (int i = 0; i < newArr.length; ++i) {
            newArr[i] = arr[i].toLowerCase();
        }
        return newArr;
    }

    static void setNamesAndValues(Model m, Object ... namesAndValues) {
        String[] names = new String[namesAndValues.length / 2];
        Object[] values = new Object[namesAndValues.length / 2];
        int j = 0;
        int i = 0;
        while (i < namesAndValues.length - 1) {
            if (namesAndValues[i] == null) {
                throw new IllegalArgumentException("attribute names cannot be nulls");
            }
            names[j] = (String)namesAndValues[i];
            values[j] = namesAndValues[i + 1];
            i += 2;
            ++j;
        }
        m.set(names, values);
    }

    static void purgeEdges(MetaModel metaModel) {
        List<Association> associations = metaModel.getAssociations();
        for (Association association : associations) {
            QueryCache.instance().purgeTableCache(association.getTarget());
        }
        List<String> edges = Registry.instance().getEdges(metaModel.getTableName());
        for (String edge : edges) {
            QueryCache.instance().purgeTableCache(edge);
        }
    }
}

