/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.javalite.activejdbc.Association;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.RowListenerAdapter;
import org.javalite.activejdbc.SuperLazyList;
import org.javalite.activejdbc.associations.BelongsToAssociation;
import org.javalite.activejdbc.associations.BelongsToPolymorphicAssociation;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.associations.OneToManyAssociation;
import org.javalite.activejdbc.associations.OneToManyPolymorphicAssociation;
import org.javalite.activejdbc.cache.QueryCache;
import org.javalite.common.Collections;
import org.javalite.common.Inflector;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyList<T extends Model>
extends AbstractList<T> {
    static final Logger logger = LoggerFactory.getLogger(LazyList.class);
    protected ArrayList<T> delegate = new ArrayList();
    private List<String> orderBys = new ArrayList<String>();
    private boolean hydrated = false;
    private MetaModel metaModel;
    private List<String> subQueries = new ArrayList<String>();
    private String fullQuery;
    private Object[] params;
    private long limit = -1L;
    private long offset = -1L;
    private Map<Class<T>, Association> includes = new HashMap<Class<T>, Association>();
    private boolean forPaginator;

    protected LazyList(String subQuery, Object[] params, MetaModel metaModel) {
        if (subQuery != null) {
            this.subQueries.add(subQuery);
        }
        this.params = params == null ? new Object[]{} : params;
        this.metaModel = metaModel;
    }

    protected LazyList(boolean forPaginator, MetaModel metaModel, String fullQuery, Object[] params) {
        this.fullQuery = fullQuery;
        this.params = params == null ? new Object[]{} : params;
        this.metaModel = metaModel;
        this.forPaginator = forPaginator;
    }

    protected LazyList() {
    }

    public <E extends Model> LazyList<E> limit(long limit) {
        if (this.fullQuery != null && !this.forPaginator) {
            throw new IllegalArgumentException("Cannot use .limit() if using free form SQL");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("limit cannot be negative");
        }
        this.limit = limit;
        return this;
    }

    public <E extends Model> LazyList<E> offset(long offset) {
        if (this.fullQuery != null && !this.forPaginator) {
            throw new IllegalArgumentException("Cannot use .offset() if using free form SQL");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        this.offset = offset;
        return this;
    }

    public <E extends Model> LazyList<E> orderBy(String orderBy) {
        if (this.fullQuery != null && !this.forPaginator) {
            throw new IllegalArgumentException("Cannot use .orderBy() if using free form SQL");
        }
        this.orderBys.add(orderBy);
        return this;
    }

    public <E extends Model> LazyList<E> include(Class<? extends Model> ... classes) {
        if (this.includes.size() != 0) {
            throw new IllegalArgumentException("Can't call include() more than once!");
        }
        for (Class<? extends Model> clazz : classes) {
            if (this.metaModel.isAssociatedTo(clazz)) continue;
            throw new IllegalArgumentException("Model: " + clazz.getName() + " is not associated with: " + this.metaModel.getModelClass().getName());
        }
        for (Class<? extends Model> includeClass : classes) {
            String table = Registry.instance().getTableName(includeClass);
            ArrayList<Association> associations = this.metaModel.getAssociationsForTarget(table);
            for (Association association : associations) {
                this.includes.put(includeClass, association);
            }
        }
        return this;
    }

    public List<Map> toMaps() {
        this.hydrate();
        ArrayList<Map> maps = new ArrayList<Map>(this.delegate.size());
        for (Model t : this.delegate) {
            maps.add(t.toMap());
        }
        return maps;
    }

    public String toXml(int spaces, boolean declaration, String ... attrs) {
        String topNode = Inflector.pluralize((String)Inflector.underscore((String)this.metaModel.getModelClass().getSimpleName()));
        this.hydrate();
        StringWriter sw = new StringWriter();
        if (declaration) {
            sw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + (spaces > 0 ? "\n" : ""));
        }
        sw.write("<" + topNode + ">" + (spaces > 0 ? "\n" : ""));
        for (Model t : this.delegate) {
            sw.write(t.toXml(spaces, false, attrs));
        }
        sw.write("</" + topNode + ">" + (spaces > 0 ? "\n" : ""));
        return sw.toString();
    }

    public String toJson(boolean pretty, String ... attrs) {
        this.hydrate();
        StringWriter sw = new StringWriter();
        sw.write("[" + (pretty ? "\n" : ""));
        ArrayList<String> items = new ArrayList<String>();
        for (Model t : this.delegate) {
            items.add(t.toJsonP(pretty, pretty ? "  " : "", attrs));
        }
        sw.write(Util.join(items, (String)("," + (pretty ? "\n" : ""))));
        sw.write((pretty ? "\n" : "") + "]");
        return sw.toString();
    }

    public <E extends Model> LazyList<E> load() {
        if (this.hydrated) {
            throw new DBException("load() must be the last on the chain of methods");
        }
        this.hydrate();
        return this;
    }

    public String toSql() {
        return this.toSql(true);
    }

    public String toSql(boolean showParameters) {
        String subQuery = Util.join((String[])this.subQueries.toArray(new String[0]), (String)" ");
        String sql = this.forPaginator ? Registry.instance().getConfiguration().getDialect(this.metaModel).formSelect(null, this.fullQuery, this.orderBys, this.limit, this.offset) : (this.fullQuery != null ? this.fullQuery : Registry.instance().getConfiguration().getDialect(this.metaModel).formSelect(this.metaModel.getTableName(), subQuery, this.orderBys, this.limit, this.offset));
        sql = sql + (showParameters ? ", with parameters: " + Collections.list((Object[])this.params) : "");
        return sql;
    }

    protected void hydrate() {
        ArrayList cached;
        if (this.hydrated) {
            return;
        }
        String sql = this.toSql(false);
        if (this.metaModel.cached() && (cached = (ArrayList)QueryCache.instance().getItem(this.metaModel.getTableName(), sql, this.params)) != null) {
            this.delegate = cached;
            return;
        }
        long start = System.currentTimeMillis();
        new DB(this.metaModel.getDbName()).find(sql, this.params).with(new RowListenerAdapter(){

            @Override
            public void onNext(Map<String, Object> rowMap) {
                LazyList.this.delegate.add(Model.instance(rowMap, LazyList.this.metaModel));
            }
        });
        LogFilter.logQuery(logger, sql, this.params, start);
        if (this.metaModel.cached()) {
            QueryCache.instance().addItem(this.metaModel.getTableName(), sql, this.params, this.delegate);
        }
        this.hydrated = true;
        this.processIncludes();
    }

    private void processIncludes() {
        for (Class<T> includedClass : this.includes.keySet()) {
            Association association = this.includes.get(includedClass);
            if (association instanceof BelongsToAssociation) {
                this.processParent((BelongsToAssociation)association, includedClass);
                continue;
            }
            if (association instanceof OneToManyAssociation) {
                this.processChildren((OneToManyAssociation)association, includedClass);
                continue;
            }
            if (association instanceof Many2ManyAssociation) {
                this.processOther((Many2ManyAssociation)association, includedClass);
                continue;
            }
            if (association instanceof OneToManyPolymorphicAssociation) {
                this.processPolymorphicChildren((OneToManyPolymorphicAssociation)association, includedClass);
                continue;
            }
            if (!(association instanceof BelongsToPolymorphicAssociation)) continue;
            this.processPolymorphicParent((BelongsToPolymorphicAssociation)association, includedClass);
        }
    }

    private void processPolymorphicParent(BelongsToPolymorphicAssociation association, Class parentClass) {
        if (this.delegate.size() == 0) {
            return;
        }
        MetaModel parentMM = Registry.instance().getMetaModel(parentClass);
        HashMap<String, Model> parentsHasByIds = new HashMap<String, Model>();
        String parentClassName = association.getParentClassName();
        List parentIds = this.collect("parent_id", "parent_type", parentClassName);
        ArrayList noDuplicateList = new ArrayList(new HashSet(parentIds));
        for (Model parent : new LazyList<T>(parentMM.getIdName() + " IN (" + Util.join(noDuplicateList, (String)", ") + ")", null, parentMM)) {
            parentsHasByIds.put(parentClassName + ":" + parent.getId(), parent);
        }
        for (Model child : this.delegate) {
            Object fk = child.get("parent_id");
            Model parent = (Model)parentsHasByIds.get(parentClassName + ":" + fk);
            child.setCachedParent(parent);
        }
    }

    private void processParent(BelongsToAssociation association, Class parentClass) {
        if (this.delegate.size() == 0) {
            return;
        }
        MetaModel parentMM = Registry.instance().getMetaModel(parentClass);
        HashMap<Object, Model> parentsHasByIds = new HashMap<Object, Model>();
        String fkName = association.getFkName();
        List parentIds = this.collect(fkName);
        ArrayList noDuplicateList = new ArrayList(new HashSet(parentIds));
        for (Model parent : new LazyList<T>(parentMM.getIdName() + " IN (" + Util.join(noDuplicateList, (String)", ") + ")", null, parentMM)) {
            parentsHasByIds.put(parent.getId(), parent);
        }
        for (Model child : this.delegate) {
            Object fk = child.get(fkName);
            Model parent = (Model)parentsHasByIds.get(fk);
            child.setCachedParent(parent);
        }
    }

    public List collect(String columnName) {
        this.hydrate();
        ArrayList<Object> results = new ArrayList<Object>();
        for (Model model : this.delegate) {
            results.add(model.get(columnName));
        }
        return results;
    }

    public List collect(String columnName, String filterColumn, Object filterValue) {
        this.hydrate();
        ArrayList<Object> results = new ArrayList<Object>();
        for (Model model : this.delegate) {
            if (!model.get(filterColumn).equals(filterValue)) continue;
            results.add(model.get(columnName));
        }
        return results;
    }

    private void processPolymorphicChildren(OneToManyPolymorphicAssociation association, Class childClass) {
        if (this.delegate.size() == 0) {
            return;
        }
        MetaModel childMM = Registry.instance().getMetaModel(childClass);
        String fkName = association.getTarget();
        HashMap childrenByParentId = new HashMap();
        List ids = this.collect(this.metaModel.getIdName());
        for (Model child : new LazyList<T>("parent_id IN (" + Util.join((Collection)ids, (String)", ") + ") AND parent_type = '" + association.getTypeLabel() + "'", null, childMM).orderBy(childMM.getIdName())) {
            if (childrenByParentId.get(child.get("parent_id")) == null) {
                childrenByParentId.put(child.get("parent_id"), new SuperLazyList());
            }
            ((List)childrenByParentId.get(child.get("parent_id"))).add(child);
        }
        for (Model parent : this.delegate) {
            List children = (List)childrenByParentId.get(parent.getId());
            if (children == null) continue;
            parent.setChildren(childClass, children);
        }
    }

    private void processChildren(OneToManyAssociation association, Class childClass) {
        if (this.delegate.size() == 0) {
            return;
        }
        MetaModel childMM = Registry.instance().getMetaModel(childClass);
        String fkName = association.getFkName();
        HashMap childrenByParentId = new HashMap();
        List ids = this.collect(this.metaModel.getIdName());
        for (Model child : new LazyList<T>(fkName + " IN (" + Util.join((Collection)ids, (String)", ") + ")", null, childMM).orderBy(childMM.getIdName())) {
            if (childrenByParentId.get(child.get(fkName)) == null) {
                childrenByParentId.put(child.get(fkName), new SuperLazyList());
            }
            ((List)childrenByParentId.get(child.get(fkName))).add(child);
        }
        for (Model parent : this.delegate) {
            List children = (List)childrenByParentId.get(parent.getId());
            if (children == null) continue;
            parent.setChildren(childClass, children);
        }
    }

    private void processOther(Many2ManyAssociation association, Class childClass) {
        if (this.delegate.size() == 0) {
            return;
        }
        MetaModel childMM = Registry.instance().getMetaModel(childClass);
        HashMap childrenByParentId = new HashMap();
        List ids = this.collect(this.metaModel.getIdName());
        String sql = "SELECT " + association.getTarget() + ".*, t." + association.getSourceFkName() + " AS the_parent_record_id FROM " + association.getTarget() + " INNER JOIN " + association.getJoin() + " t ON " + association.getTarget() + "." + association.getTargetPk() + " = t." + association.getTargetFkName() + " WHERE (t." + association.getSourceFkName() + "  IN (" + Util.join((Collection)ids, (String)", ") + "))";
        List<Map> childResults = new DB(childMM.getDbName()).findAll(sql);
        for (Map res : childResults) {
            Object child = Model.instance(res, childMM);
            Object parentId = res.get("the_parent_record_id");
            if (childrenByParentId.get(parentId) == null) {
                childrenByParentId.put(parentId, new SuperLazyList());
            }
            ((List)childrenByParentId.get(parentId)).add(child);
        }
        for (Model parent : this.delegate) {
            List children = (List)childrenByParentId.get(parent.getId());
            if (children == null) continue;
            parent.setChildren(childClass, children);
        }
    }

    @Override
    public T get(int index) {
        this.hydrate();
        return (T)((Model)this.delegate.get(index));
    }

    @Override
    public int size() {
        this.hydrate();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.hydrate();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.hydrate();
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        this.hydrate();
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        this.hydrate();
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.hydrate();
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException("this operation is not supported, cannot manipulate DB results");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("this operation is not supported, cannot manipulate DB results");
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("this operation is not supported, cannot manipulate DB results");
    }

    @Override
    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException("this operation is not supported, cannot manipulate DB results");
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("this operation is not supported, cannot manipulate DB results");
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("this operation is not supported, cannot manipulate DB results");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("this operation is not supported, cannot manipulate DB results");
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("this operation is not supported, cannot manipulate DB results");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("this operation is not supported, cannot manipulate DB results");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("this operation is not supported, cannot manipulate DB results");
    }

    @Override
    public int indexOf(Object o) {
        this.hydrate();
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.hydrate();
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        this.hydrate();
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        this.hydrate();
        return this.delegate.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        this.hydrate();
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public int hashCode() {
        this.hydrate();
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        this.hydrate();
        return this.delegate.toString();
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(OutputStream out) {
        this.hydrate();
        PrintWriter p = new PrintWriter(out);
        for (Model m : this.delegate) {
            p.write(m.toString() + "\n");
        }
        p.flush();
    }
}

