/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.javalite.activejdbc.ConnectionJdbcSpec;
import org.javalite.activejdbc.ConnectionJndiSpec;
import org.javalite.activejdbc.ConnectionSpec;
import org.javalite.activejdbc.ConnectionsAccess;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.RowListener;
import org.javalite.activejdbc.RowListenerAdapter;
import org.javalite.activejdbc.RowProcessor;
import org.javalite.activejdbc.StatementCache;
import org.javalite.common.Convert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB {
    private String dbName;
    static final Logger logger = LoggerFactory.getLogger(DB.class);

    public DB(String dbName) {
        this.dbName = dbName;
    }

    public void open(String driver, String url, String user, String password) {
        this.checkExistingConnection(this.dbName);
        try {
            Class.forName(driver);
            Connection connection = DriverManager.getConnection(url, user, password);
            ConnectionsAccess.attach(this.dbName, connection);
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JDBC URL: " + url, e);
        }
    }

    public void open(String driver, String url, Properties props) {
        this.checkExistingConnection(this.dbName);
        try {
            Class.forName(driver);
            Connection connection = DriverManager.getConnection(url, props);
            ConnectionsAccess.attach(this.dbName, connection);
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JDBC URL: " + url, e);
        }
    }

    public void open(String jndiName) {
        this.checkExistingConnection(this.dbName);
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(jndiName);
            Connection connection = ds.getConnection();
            ConnectionsAccess.attach(this.dbName, connection);
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JNDI name: " + jndiName, e);
        }
    }

    public void open(DataSource datasource) {
        this.checkExistingConnection(this.dbName);
        try {
            Connection connection = datasource.getConnection();
            ConnectionsAccess.attach(this.dbName, connection);
        }
        catch (Exception e) {
            throw new InitException(e);
        }
    }

    public void open(String jndiName, Properties jndiProperties) {
        this.checkExistingConnection(this.dbName);
        try {
            InitialContext ctx = new InitialContext(jndiProperties);
            DataSource ds = (DataSource)ctx.lookup(jndiName);
            Connection connection = ds.getConnection();
            ConnectionsAccess.attach(this.dbName, connection);
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JNDI name: " + jndiName, e);
        }
    }

    public void open(ConnectionSpec spec) {
        this.checkExistingConnection(this.dbName);
        if (spec instanceof ConnectionJdbcSpec) {
            this.openJdbc((ConnectionJdbcSpec)spec);
        } else if (spec instanceof ConnectionJndiSpec) {
            this.openJndi((ConnectionJndiSpec)spec);
        } else {
            throw new IllegalArgumentException("this spec not supported: " + spec.getClass());
        }
    }

    private void checkExistingConnection(String dbName) {
        if (null != ConnectionsAccess.getConnection(dbName)) {
            throw new DBException("Cannot open a new connection because existing connection is still on current thread, dbName: " + dbName + ", connection instance: " + this.connection() + ". This might indicate a logical error in your application.");
        }
    }

    private void openJdbc(ConnectionJdbcSpec spec) {
        if (spec.getProps() != null) {
            this.open(spec.getDriver(), spec.getUrl(), spec.getProps());
        } else {
            this.open(spec.getDriver(), spec.getUrl(), spec.getUser(), spec.getPassword());
        }
    }

    private void openJndi(ConnectionJndiSpec spec) {
        if (spec.getContext() != null) {
            this.openContext(spec.getContext(), spec.getDataSourceJndiName());
        } else {
            this.open(spec.getDataSourceJndiName());
        }
    }

    private void openContext(InitialContext context, String jndiName) {
        try {
            DataSource ds = (DataSource)context.lookup(jndiName);
            Connection connection = ds.getConnection();
            ConnectionsAccess.attach(this.dbName, connection);
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JNDI name: " + jndiName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Connection connection = ConnectionsAccess.getConnection(this.dbName);
            if (connection == null) {
                throw new DBException("cannot close connection '" + this.dbName + "' because it is not available");
            }
            StatementCache.instance().cleanStatementCache(connection);
            connection.close();
            LogFilter.log(logger, "Closed connection: " + connection);
        }
        catch (Exception e) {
            logger.warn("Could not close connection! MUST INVESTIGATE POTENTIAL CONNECTION LEAK!", (Throwable)e);
        }
        finally {
            ConnectionsAccess.detach(this.dbName);
        }
    }

    public Long count(String table) {
        String sql = "SELECT COUNT(*) FROM " + table;
        return Convert.toLong((Object)this.firstCell(sql, new Object[0]));
    }

    public Long count(String table, String query, Object ... params) {
        if (query.trim().equals("*") && params.length == 0) {
            return this.count(table);
        }
        if (query.trim().equals("*") && params.length != 0) {
            throw new IllegalArgumentException("cannot use '*' and parameters");
        }
        String sql = "SELECT COUNT(*) FROM " + table + " WHERE " + query;
        return Convert.toLong((Object)this.firstCell(sql, params));
    }

    public Object firstCell(String query, Object ... params) {
        List<Map> list = this.findAll(query, params);
        if (list.size() == 0) {
            return null;
        }
        Map map = list.get(0);
        if (map.size() > 1) {
            throw new IllegalArgumentException("query: " + query + " selects more than one column");
        }
        return map.get(map.keySet().toArray()[0]);
    }

    public List<Map> findAll(String query, Object ... params) {
        long start = System.currentTimeMillis();
        final ArrayList<Map> results = new ArrayList<Map>();
        this.find(query, params).with(new RowListenerAdapter(){

            @Override
            public void onNext(Map<String, Object> row) {
                results.add(row);
            }
        });
        LogFilter.logQuery(logger, query, params, start);
        return results;
    }

    public List firstColumn(String query, Object ... params) {
        final ArrayList results = new ArrayList();
        long start = System.currentTimeMillis();
        this.find(query, params).with(new RowListenerAdapter(){

            @Override
            public void onNext(Map<String, Object> row) {
                if (row.size() > 1) {
                    throw new IllegalArgumentException("Query selects more than one column");
                }
                results.add(row.get(row.keySet().toArray()[0]));
            }
        });
        LogFilter.logQuery(logger, query, params, start);
        return results;
    }

    public List<Map> findAll(String query) {
        final ArrayList<Map> results = new ArrayList<Map>();
        long start = System.currentTimeMillis();
        this.find(query, new Object[0]).with(new RowListenerAdapter(){

            @Override
            public void onNext(Map<String, Object> row) {
                results.add(row);
            }
        });
        LogFilter.logQuery(logger, query, null, start);
        return results;
    }

    public RowProcessor find(String query, Object ... params) {
        if (query.indexOf(63) == -1 && params.length != 0) {
            throw new IllegalArgumentException("you passed arguments, but the query does not have placeholders: (?)");
        }
        if (!query.toLowerCase().contains("select")) {
            throw new IllegalArgumentException("query must be 'select' query");
        }
        try {
            PreparedStatement ps = this.createStreamingPreparedStatement(query);
            for (int index = 0; index < params.length; ++index) {
                Object param = params[index];
                ps.setObject(index + 1, param);
            }
            ResultSet rs = ps.executeQuery();
            return new RowProcessor(rs, ps);
        }
        catch (Exception e) {
            throw new DBException(query, params, e);
        }
    }

    private PreparedStatement createStreamingPreparedStatement(String query) throws SQLException {
        PreparedStatement res;
        Connection conn = this.connection();
        if ("mysql".equalsIgnoreCase(conn.getMetaData().getDatabaseProductName())) {
            res = conn.prepareStatement(query, 1003, 1007);
            res.setFetchSize(Integer.MIN_VALUE);
        } else {
            res = conn.prepareStatement(query);
        }
        return res;
    }

    public void find(String sql, RowListener listener) {
        Statement s = null;
        ResultSet rs = null;
        try {
            s = this.createStreamingStatement();
            rs = s.executeQuery(sql);
            RowProcessor p = new RowProcessor(rs, s);
            p.with(listener);
        }
        catch (Exception e) {
            throw new DBException(sql, null, e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private Statement createStreamingStatement() throws SQLException {
        Statement res;
        Connection conn = this.connection();
        if ("mysql".equalsIgnoreCase(conn.getMetaData().getDatabaseProductName())) {
            res = conn.createStatement(1003, 1007);
            res.setFetchSize(Integer.MIN_VALUE);
        } else {
            res = conn.createStatement();
        }
        return res;
    }

    public int exec(String query) {
        long start = System.currentTimeMillis();
        Statement s = null;
        try {
            s = this.connection().createStatement();
            int count = s.executeUpdate(query);
            LogFilter.logQuery(logger, query, null, start);
            int n = count;
            return n;
        }
        catch (SQLException e) {
            logger.error("Query failed: " + query, (Throwable)e);
            throw new DBException(query, null, e);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public int exec(String query, Object ... params) {
        if (query.trim().toLowerCase().startsWith("select")) {
            throw new IllegalArgumentException("expected DML, but got select...");
        }
        if (query.indexOf(63) == -1) {
            throw new IllegalArgumentException("query must be parametrized");
        }
        long start = System.currentTimeMillis();
        PreparedStatement ps = null;
        try {
            ps = this.connection().prepareStatement(query);
            for (int index = 0; index < params.length; ++index) {
                Object param = params[index];
                ps.setObject(index + 1, param);
            }
            int count = ps.executeUpdate();
            LogFilter.logQuery(logger, query, params, start);
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new DBException(query, params, e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long execInsert(String query, String autoIncrementColumnName, Object ... params) {
        if (!query.toLowerCase().contains("insert")) {
            throw new IllegalArgumentException("this method is only for inserts");
        }
        long start = System.currentTimeMillis();
        try {
            Connection connection = this.connection();
            PreparedStatement ps = StatementCache.instance().getPreparedStatement(connection, query);
            if (ps == null) {
                ps = connection.prepareStatement(query, new String[]{autoIncrementColumnName});
                StatementCache.instance().cache(connection, query, ps);
            }
            for (int index = 0; index < params.length; ++index) {
                Object param = params[index];
                ps.setObject(index + 1, param);
            }
            ps.executeUpdate();
            ResultSet rs = null;
            try {
                rs = ps.getGeneratedKeys();
                if (rs.next()) {
                    long id = rs.getLong(1);
                    LogFilter.logQuery(logger, query, params, start);
                    long l = id;
                    return l;
                }
                long id = -1L;
                return id;
            }
            catch (Exception e) {
                this.logException("Failed to find out the auto-incremented value, returning -1, query: " + query, e);
                long l = -1L;
                return l;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e4) {}
            }
        }
        catch (Exception e3) {
            throw new DBException(query, params, e3);
        }
    }

    private void logException(String message, Exception e) {
        logger.error(message, (Throwable)e);
    }

    public void openTransaction() {
        try {
            Connection c = ConnectionsAccess.getConnection(this.dbName);
            if (c == null) {
                throw new DBException("Cannot open transaction, connection '" + this.dbName + "' not available");
            }
            c.setAutoCommit(false);
            LogFilter.log(logger, "Transaction opened");
        }
        catch (SQLException ex) {
            throw new DBException(ex.getMessage(), ex);
        }
    }

    public void commitTransaction() {
        try {
            Connection c = ConnectionsAccess.getConnection(this.dbName);
            if (c == null) {
                throw new DBException("Cannot commit transaction, connection '" + this.dbName + "' not available");
            }
            c.commit();
            LogFilter.log(logger, "Transaction committed");
        }
        catch (SQLException ex) {
            throw new DBException(ex.getMessage(), ex);
        }
    }

    public void rollbackTransaction() {
        try {
            Connection c = ConnectionsAccess.getConnection(this.dbName);
            if (c == null) {
                throw new DBException("Cannot rollback transaction, connection '" + this.dbName + "' not available");
            }
            c.rollback();
            LogFilter.log(logger, "Transaction rolled back");
        }
        catch (SQLException ex) {
            throw new DBException(ex.getMessage(), ex);
        }
    }

    public Connection connection() {
        Connection connection = ConnectionsAccess.getConnection(this.dbName);
        if (connection == null) {
            throw new DBException("there is no connection '" + this.dbName + "' on this thread, are you sure you opened it?");
        }
        return connection;
    }

    public boolean hasConnection() {
        return null != ConnectionsAccess.getConnection(this.dbName);
    }

    public Connection getConnection() {
        return this.connection();
    }

    public static List<String> getCurrrentConnectionNames() {
        return new ArrayList<String>(ConnectionsAccess.getConnectionMap().keySet());
    }

    public static void closeAllConnections() {
        List<String> names = DB.getCurrrentConnectionNames();
        for (String name : names) {
            new DB(name).close();
        }
    }

    public static Map<String, Connection> connections() {
        return ConnectionsAccess.getConnectionMap();
    }
}

