/*
 * Decompiled with CFR 0.152.
 */
package org.javafunk.excelparser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Sheet;
import org.javafunk.excelparser.annotations.ExcelField;
import org.javafunk.excelparser.annotations.ExcelObject;
import org.javafunk.excelparser.annotations.MappedExcelObject;
import org.javafunk.excelparser.annotations.ParseType;
import org.javafunk.excelparser.exception.ExcelParsingException;
import org.javafunk.excelparser.helper.HSSFHelper;

public class SheetParser {
    public <T> List<T> createEntity(Sheet sheet, Class<T> clazz, Consumer<ExcelParsingException> errorHandler) {
        ArrayList<T> list = new ArrayList<T>();
        ExcelObject excelObject = this.getExcelObject(clazz, errorHandler);
        for (int currentLocation = excelObject.start(); currentLocation <= excelObject.end(); ++currentLocation) {
            T object = this.getNewInstance(sheet, clazz, excelObject.parseType(), currentLocation, excelObject.zeroIfNull(), errorHandler);
            List<Field> mappedExcelFields = this.getMappedExcelObjects(clazz);
            for (Field mappedField : mappedExcelFields) {
                Class<?> fieldType = mappedField.getType();
                Class<?> clazz1 = fieldType.equals(List.class) ? this.getFieldType(mappedField) : fieldType;
                List<?> fieldValue = this.createEntity(sheet, clazz1, errorHandler);
                if (fieldType.equals(List.class)) {
                    this.setFieldValue(mappedField, object, fieldValue);
                    continue;
                }
                if (fieldValue.isEmpty()) continue;
                this.setFieldValue(mappedField, object, fieldValue.get(0));
            }
            list.add(object);
        }
        return list;
    }

    @Deprecated
    public <T> List<T> createEntity(Sheet sheet, String sheetName, Class<T> clazz) {
        return this.createEntity(sheet, clazz, (ExcelParsingException error) -> {
            throw error;
        });
    }

    private Class<?> getFieldType(Field field) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getActualTypeArguments()[0];
        }
        return null;
    }

    private <T> List<Field> getMappedExcelObjects(Class<T> clazz) {
        Field[] fields;
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            MappedExcelObject mappedExcelObject = field.getAnnotation(MappedExcelObject.class);
            if (mappedExcelObject == null) continue;
            field.setAccessible(true);
            fieldList.add(field);
        }
        return fieldList;
    }

    private <T> ExcelObject getExcelObject(Class<T> clazz, Consumer<ExcelParsingException> errorHandler) {
        ExcelObject excelObject = clazz.getAnnotation(ExcelObject.class);
        if (excelObject == null) {
            errorHandler.accept(new ExcelParsingException("Invalid class configuration - ExcelObject annotation missing - " + clazz.getSimpleName()));
        }
        return excelObject;
    }

    private <T> T getNewInstance(Sheet sheet, Class<T> clazz, ParseType parseType, Integer currentLocation, boolean zeroIfNull, Consumer<ExcelParsingException> errorHandler) {
        T object = this.getInstance(clazz, errorHandler);
        Map<Integer, Field> excelPositionMap = this.getExcelFieldPositionMap(clazz);
        for (Integer position : excelPositionMap.keySet()) {
            Field field = excelPositionMap.get(position);
            Object cellValue = ParseType.ROW == parseType ? HSSFHelper.getCellValue(sheet, field.getType(), currentLocation, position, zeroIfNull, errorHandler) : HSSFHelper.getCellValue(sheet, field.getType(), position, currentLocation, zeroIfNull, errorHandler);
            this.setFieldValue(field, object, cellValue);
        }
        return object;
    }

    private <T> T getInstance(Class<T> clazz, Consumer<ExcelParsingException> errorHandler) {
        T object;
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            object = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            errorHandler.accept(new ExcelParsingException("Exception occurred while instantiating the class " + clazz.getName(), e));
            return null;
        }
        return object;
    }

    private <T> void setFieldValue(Field field, T object, Object cellValue) {
        try {
            field.set(object, cellValue);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ExcelParsingException("Exception occurred while setting field value ", e);
        }
    }

    private <T> Map<Integer, Field> getExcelFieldPositionMap(Class<T> clazz) {
        Field[] fields;
        HashMap<Integer, Field> fieldMap = new HashMap<Integer, Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            ExcelField excelField = field.getAnnotation(ExcelField.class);
            if (excelField == null) continue;
            field.setAccessible(true);
            fieldMap.put(excelField.position(), field);
        }
        return fieldMap;
    }
}

