/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.plugin.gradle.javacc.programexecution;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RelativePath;
import org.javacc.plugin.gradle.javacc.programexecution.AbstractProgramInvoker;
import org.javacc.plugin.gradle.javacc.programexecution.JjtreeExecutorAction;
import org.javacc.plugin.gradle.javacc.programexecution.ProgramArguments;

public class JjtreeProgramInvoker
extends AbstractProgramInvoker {
    public static final String SUPPORTED_FILE_SUFFIX = ".jjt";
    private final String outputDirectoryArgName = this.getOutputDirectoryArgName();

    public JjtreeProgramInvoker(Project project, Configuration classpath, File tempOutputDirectory) {
        super(project, classpath, tempOutputDirectory, JjtreeExecutorAction.class);
    }

    private String getOutputDirectoryArgName() {
        Integer[] version = this.getJavaccVersion();
        if (version[0] == 4 && version[1] <= 0) {
            return "OUTPUT_DIRECTORY";
        }
        return "JJTREE_OUTPUT_DIRECTORY";
    }

    @Override
    public ProgramArguments augmentArguments(File inputDirectory, RelativePath inputRelativePath, ProgramArguments arguments) {
        ProgramArguments augmentedArguments = new ProgramArguments(arguments);
        augmentedArguments.add(this.outputDirectoryArgName, inputRelativePath.getFile(this.tempOutputDirectory).getParentFile().getAbsolutePath());
        this.addCodeGenerator(augmentedArguments);
        return augmentedArguments;
    }

    @Override
    public String getProgramName() {
        return "JJTree";
    }

    @Override
    public String supportedSuffix() {
        return SUPPORTED_FILE_SUFFIX;
    }
}

