/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.plugin.gradle.javacc.compiler;

import java.io.File;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.javacc.plugin.gradle.javacc.compiler.SourceFileCompiler;

class JavaccSourceFileVisitor
extends EmptyFileVisitor {
    private SourceFileCompiler compiler;

    JavaccSourceFileVisitor(SourceFileCompiler compiler) {
        this.compiler = compiler;
    }

    public void visitFile(FileVisitDetails fileDetails) {
        if (this.isValidSourceFileForTask(fileDetails)) {
            this.compiler.compile(this.computeInputDirectory(fileDetails), fileDetails.getRelativePath());
        } else {
            this.compiler.getLogger().debug("Skipping file {} as it is not supported by program {}", (Object)fileDetails.getFile().getAbsolutePath(), (Object)this.compiler.getProgramName());
        }
    }

    private boolean isValidSourceFileForTask(FileVisitDetails fileDetails) {
        return fileDetails.getName().toLowerCase().endsWith(this.compiler.supportedSuffix());
    }

    private File computeInputDirectory(FileVisitDetails fileVisitDetails) {
        File fileAbsolute = fileVisitDetails.getFile();
        File fileRelative = new File(fileVisitDetails.getPath());
        return new File(fileAbsolute.getAbsolutePath().replace(fileRelative.getPath(), ""));
    }
}

