/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.plugin.gradle.javacc.compiler;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.logging.Logger;
import org.javacc.plugin.gradle.javacc.JavaccTaskException;
import org.javacc.plugin.gradle.javacc.compilationresults.CompiledJavaccFile;
import org.javacc.plugin.gradle.javacc.compilationresults.CompiledJavaccFilesDirectory;
import org.javacc.plugin.gradle.javacc.compilationresults.CompiledJavaccFilesDirectoryFactory;
import org.javacc.plugin.gradle.javacc.compiler.CompilerInputOutputConfiguration;
import org.javacc.plugin.gradle.javacc.compiler.JavaccSourceFileVisitor;
import org.javacc.plugin.gradle.javacc.compiler.NonJavaccSourceFileVisitor;
import org.javacc.plugin.gradle.javacc.compiler.SourceFileCompiler;
import org.javacc.plugin.gradle.javacc.programexecution.ProgramArguments;
import org.javacc.plugin.gradle.javacc.programexecution.ProgramInvoker;

public class JavaccSourceFileCompiler
implements SourceFileCompiler {
    private final ProgramInvoker programInvoker;
    private final ProgramArguments argumentsProvidedByTask;
    private final CompilerInputOutputConfiguration configuration;
    private CompiledJavaccFilesDirectoryFactory compiledJavaccFilesDirectoryFactory = new CompiledJavaccFilesDirectoryFactory();
    private final Logger logger;

    public JavaccSourceFileCompiler(ProgramInvoker programInvoker, ProgramArguments argumentsProvidedByTask, CompilerInputOutputConfiguration configuration, Logger logger) {
        this.programInvoker = programInvoker;
        this.argumentsProvidedByTask = argumentsProvidedByTask;
        this.configuration = configuration;
        this.logger = logger;
    }

    @Override
    public void compileSourceFilesToTempOutputDirectory() {
        this.configuration.getSource().visit(this.getJavaccSourceFileVisitor());
    }

    private FileVisitor getJavaccSourceFileVisitor() {
        return new JavaccSourceFileVisitor(this);
    }

    @Override
    public void copyNonJavaccFilesToOutputDirectory() {
        this.configuration.getSource().visit(this.getNonJavaccSourceFileVisitor());
    }

    private FileVisitor getNonJavaccSourceFileVisitor() {
        return new NonJavaccSourceFileVisitor(this);
    }

    @Override
    public void compile(File inputDirectory, RelativePath inputRelativePath) {
        this.logger.debug("Compiling {} file [{}] from [{}] into [{}]", new Object[]{this.programInvoker.getProgramName(), inputRelativePath, inputDirectory, this.getOutputDirectory()});
        ProgramArguments arguments = this.buildProgramArguments(inputDirectory, inputRelativePath);
        this.logger.debug("Invoking {} with arguments [{}]", (Object)this.programInvoker.getProgramName(), (Object)arguments);
        try {
            this.programInvoker.invokeCompiler(arguments);
        }
        catch (Exception exception) {
            String errorMessage = String.format("Unable to compile '%s' from '%s' into '%s'", inputRelativePath, inputDirectory, this.getOutputDirectory());
            throw new JavaccTaskException(errorMessage, exception);
        }
    }

    private ProgramArguments buildProgramArguments(File inputDirectory, RelativePath inputRelativePath) {
        ProgramArguments commandLineArguments = new ProgramArguments(this.argumentsProvidedByTask);
        commandLineArguments.addFilename(inputRelativePath.getFile(inputDirectory).getAbsolutePath());
        return this.programInvoker.augmentArguments(inputDirectory, inputRelativePath, commandLineArguments);
    }

    @Override
    public void copyCompiledFilesFromTempOutputDirectoryToOutputDirectory() {
        CompiledJavaccFilesDirectory compiledJavaccFilesDirectory = this.compiledJavaccFilesDirectoryFactory.getCompiledJavaccFilesDirectory(this.configuration.getTempOutputDirectory(), this.getOutputDirectory(), this.getLogger());
        Collection<File> javaSourceFiles = this.getFiles(this.configuration.getJavaSourceTree());
        Collection<File> javaccSourceFiles = this.getFiles(this.configuration.getSource());
        for (CompiledJavaccFile compiledJavaccFile : compiledJavaccFilesDirectory.listFiles()) {
            if (compiledJavaccFile.handleCustomAstInJava(javaSourceFiles) || compiledJavaccFile.handleCustomAstInJavacc(javaccSourceFiles)) continue;
            compiledJavaccFile.copyCompiledFileToTargetDirectory();
        }
    }

    private Collection<File> getFiles(FileTree javaSourceTree) {
        if (javaSourceTree == null) {
            return Collections.emptySet();
        }
        return javaSourceTree.getFiles();
    }

    @Override
    public String supportedSuffix() {
        return this.programInvoker.supportedSuffix();
    }

    @Override
    public String getProgramName() {
        return this.programInvoker.getProgramName();
    }

    @Override
    public File getOutputDirectory() {
        return this.configuration.getOutputDirectory();
    }

    @Override
    public File getInputDirectory() {
        return this.configuration.getInputDirectory();
    }

    @Override
    public void createTempOutputDirectory() {
        this.configuration.getTempOutputDirectory().mkdirs();
    }

    @Override
    public void cleanTempOutputDirectory() {
        FileUtils.deleteQuietly((File)this.configuration.getTempOutputDirectory());
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    void setCompiledJavaccFilesDirectoryFactoryForTest(CompiledJavaccFilesDirectoryFactory factory) {
        this.compiledJavaccFilesDirectoryFactory = factory;
    }
}

