/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.plugin.gradle.javacc;

import java.util.HashMap;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.javacc.plugin.gradle.javacc.AbstractJavaccTask;
import org.javacc.plugin.gradle.javacc.CompileJavaccTask;
import org.javacc.plugin.gradle.javacc.CompileJjdocTask;
import org.javacc.plugin.gradle.javacc.CompileJjtreeTask;
import org.javacc.plugin.gradle.javacc.JavaToJavaccDependencyAction;
import org.javacc.plugin.gradle.javacc.JavaccExtension;

public class JavaccPlugin
implements Plugin<Project> {
    public static final String GROUP = "JavaCC";

    public void apply(Project project) {
        Configuration configuration = this.createJavaccConfiguration(project);
        this.configureDefaultJavaccDependency(project, configuration);
        this.addCompileJavaccTaskToProject(project, configuration);
        this.addCompileJJTreeTaskToProject(project, configuration);
        this.addCompileJjdocTaskToProject(project, configuration);
        project.getExtensions().create("javacc", JavaccExtension.class, new Object[0]);
        this.configureTaskDependencies(project);
    }

    private Configuration createJavaccConfiguration(Project project) {
        Configuration configuration = (Configuration)project.getConfigurations().create("javacc");
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The javacc dependencies to be used.");
        return configuration;
    }

    private void configureDefaultJavaccDependency(Project project, Configuration configuration) {
        configuration.defaultDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)"net.java.dev.javacc:javacc:7.0.12")));
    }

    private void addCompileJavaccTaskToProject(Project project, Configuration configuration) {
        this.addTaskToProject(project, CompileJavaccTask.class, "compileJavacc", "Compiles JavaCC files into Java files", GROUP, configuration);
    }

    private void addCompileJJTreeTaskToProject(Project project, Configuration configuration) {
        this.addTaskToProject(project, CompileJjtreeTask.class, "compileJjtree", "Compiles JJTree files into JavaCC files", GROUP, configuration);
    }

    private void addCompileJjdocTaskToProject(Project project, Configuration configuration) {
        this.addTaskToProject(project, CompileJjdocTask.class, "jjdoc", "Takes a JavaCC parser specification and produces documentation for the BNF grammar", GROUP, configuration);
    }

    private void addTaskToProject(Project project, Class<? extends AbstractJavaccTask> type, String name, String description, String group, Configuration configuration) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("type", type);
        options.put("description", description);
        options.put("group", group);
        AbstractJavaccTask task = (AbstractJavaccTask)project.task(options, name);
        task.getConventionMapping().map("classpath", () -> configuration);
    }

    private void configureTaskDependencies(Project project) {
        JavaToJavaccDependencyAction compileJavaDependsOnCompileJavacc = new JavaToJavaccDependencyAction();
        project.afterEvaluate((Action)compileJavaDependsOnCompileJavacc);
    }
}

