/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.plugin.gradle.javacc;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.compile.JavaCompile;
import org.javacc.plugin.gradle.javacc.CompileJavaccTask;
import org.javacc.plugin.gradle.javacc.CompileJjtreeTask;
import org.javacc.plugin.gradle.javacc.JavaccExtension;

public class JavaToJavaccDependencyAction
implements Action<Project> {
    public void execute(Project project) {
        if (!project.getPlugins().hasPlugin("java")) {
            return;
        }
        Collection javaTasks = project.getTasks().withType(JavaCompile.class).stream().filter(this.getJavaTaskFilter(project)).collect(Collectors.toList());
        this.configureCompileJJTreeTask(project, javaTasks);
        this.configureCompileJavaccTask(project, javaTasks);
    }

    private Predicate<? super JavaCompile> getJavaTaskFilter(Project project) {
        JavaccExtension extension = (JavaccExtension)project.getExtensions().findByName("javacc");
        if (extension != null && extension.dependentSourceSets != null) {
            return task -> extension.dependentSourceSets.stream().anyMatch(set -> set.getCompileJavaTaskName().equals(task.getName()));
        }
        return any -> true;
    }

    private void configureCompileJJTreeTask(Project project, Collection<JavaCompile> javaTasks) {
        CompileJjtreeTask compileJjtreeTask = (CompileJjtreeTask)((Object)project.getTasks().findByName("compileJjtree"));
        if (compileJjtreeTask == null) {
            return;
        }
        if (!compileJjtreeTask.getSource().isEmpty()) {
            this.addJJTreeDependencyToJavaccCompileTask(javaTasks, (TaskCollection<CompileJavaccTask>)project.getTasks().withType(CompileJavaccTask.class), compileJjtreeTask);
        }
    }

    private void configureCompileJavaccTask(Project project, Collection<JavaCompile> javaTasks) {
        CompileJavaccTask compileJavaccTask = (CompileJavaccTask)((Object)project.getTasks().findByName("compileJavacc"));
        if (compileJavaccTask != null) {
            this.addJavaccDependencyToJavaCompileTask(javaTasks, compileJavaccTask);
        }
    }

    private void addJavaccDependencyToJavaCompileTask(Collection<JavaCompile> javaCompilationTasks, CompileJavaccTask compileJavaccTask) {
        for (JavaCompile task : javaCompilationTasks) {
            task.dependsOn(new Object[]{compileJavaccTask});
            task.source(new Object[]{compileJavaccTask.getOutputDirectory()});
        }
    }

    private void addJJTreeDependencyToJavaccCompileTask(Collection<JavaCompile> javaCompilationTasks, TaskCollection<CompileJavaccTask> javaccCompilationTasks, CompileJjtreeTask compileJjtreeTask) {
        for (Object task : javaCompilationTasks) {
            task.dependsOn(new Object[]{compileJjtreeTask});
            task.source(new Object[]{compileJjtreeTask.getOutputDirectory()});
        }
        for (Object task : javaccCompilationTasks) {
            task.dependsOn(new Object[]{compileJjtreeTask});
            task.source(new Object[]{compileJjtreeTask.getOutputDirectory()});
        }
    }
}

