/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.plugin.gradle.javacc;

import java.io.File;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.compile.JavaCompile;
import org.javacc.plugin.gradle.javacc.AbstractJavaccTask;
import org.javacc.plugin.gradle.javacc.compiler.JavaccCompilerInputOutputConfiguration;
import org.javacc.plugin.gradle.javacc.compiler.JavaccSourceFileCompiler;
import org.javacc.plugin.gradle.javacc.programexecution.JjdocProgramInvoker;
import org.javacc.plugin.gradle.javacc.programexecution.ProgramArguments;

public class CompileJjdocTask
extends AbstractJavaccTask {
    public static final String TASK_NAME_VALUE = "jjdoc";
    public static final String TASK_DESCRIPTION_VALUE = "Takes a JavaCC parser specification and produces documentation for the BNF grammar";
    private static final String DEFAULT_INPUT_DIRECTORY = File.separator + "src" + File.separator + "main" + File.separator + "javacc";
    private static final String DEFAULT_OUTPUT_DIRECTORY = File.separator + "generated" + File.separator + "jjdoc";

    public CompileJjdocTask() {
        super(DEFAULT_INPUT_DIRECTORY, DEFAULT_OUTPUT_DIRECTORY, "**/*.jj");
    }

    @TaskAction
    public void run() {
        TaskCollection javaCompileTasks = this.getProject().getTasks().withType(JavaCompile.class);
        JavaccCompilerInputOutputConfiguration inputOutputDirectories = new JavaccCompilerInputOutputConfiguration(this.getInputDirectory(), this.getOutputDirectory(), this.getSource(), (TaskCollection<JavaCompile>)javaCompileTasks);
        JjdocProgramInvoker jjdocInvoker = new JjdocProgramInvoker(this.getProject(), this.getClasspath(), inputOutputDirectories.getTempOutputDirectory());
        ProgramArguments arguments = new ProgramArguments();
        arguments.addAll(this.getArguments());
        JavaccSourceFileCompiler compiler = new JavaccSourceFileCompiler(jjdocInvoker, arguments, inputOutputDirectories, this.getLogger());
        compiler.createTempOutputDirectory();
        compiler.compileSourceFilesToTempOutputDirectory();
        compiler.copyCompiledFilesFromTempOutputDirectoryToOutputDirectory();
        compiler.cleanTempOutputDirectory();
    }
}

