/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.plugin.gradle.javacc;

import java.io.File;
import java.util.Map;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceTask;

public abstract class AbstractJavaccTask
extends SourceTask {
    protected Map<String, String> programArguments;
    private File inputDirectory;
    private File outputDirectory;
    private Configuration classpath;

    protected AbstractJavaccTask(String inputDirectory, String outputDirectory, String filter) {
        this.setInputDirectory(inputDirectory);
        this.setOutputDirectory(outputDirectory);
        this.include(new String[]{filter});
    }

    @Internal
    public Map<String, String> getArguments() {
        return this.programArguments;
    }

    public AbstractJavaccTask setArguments(Map<String, String> arguments) {
        this.programArguments = arguments;
        return this;
    }

    @InputDirectory
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    public File getInputDirectory() {
        if (!this.inputDirectory.exists()) {
            return null;
        }
        return this.inputDirectory;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public AbstractJavaccTask setInputDirectory(String inputDirectory) {
        return this.setInputDirectory(new File(this.getProject().getProjectDir(), inputDirectory));
    }

    public AbstractJavaccTask setInputDirectory(File inputDirectory) {
        this.getLogger().debug("Changing input directory to [{}]", (Object)inputDirectory);
        this.inputDirectory = inputDirectory;
        this.setSource(inputDirectory);
        return this;
    }

    public AbstractJavaccTask setOutputDirectory(String outputDirectory) {
        return this.setOutputDirectory(new File(this.getProject().getBuildDir(), outputDirectory));
    }

    public AbstractJavaccTask setOutputDirectory(File outputDirectory) {
        this.getLogger().debug("Changing output directory to [{}]", (Object)outputDirectory);
        this.outputDirectory = outputDirectory;
        return this;
    }

    @Internal
    protected Configuration getClasspath() {
        return this.classpath;
    }
}

