/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resourceserver.utils.taglib;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class ResourceIncludeTag
extends TagSupport {
    private static final long serialVersionUID = 3381609818020633671L;
    public static final String RESOURCE_CONTEXT_INIT_PARAM = "resourceContextPath";
    public static final String DEFAULT_RESOURCE_CONTEXT = "/ResourceServingWebapp";
    private static final String RESOURCE_URL_ATTR_BASE = ResourceIncludeTag.class.getName() + ".resourceUrlBase.";
    protected String _var;
    protected String _url;
    protected String _resource;

    public int doStartTag() throws JspException {
        HttpServletRequest httpServletRequet = (HttpServletRequest)this.pageContext.getRequest();
        ServletContext servletContext = this.pageContext.getServletContext();
        this._url = this.getRelativeUrlString(httpServletRequet, servletContext, this._resource);
        return 1;
    }

    private String getRelativeUrlString(HttpServletRequest httpServletRequest, ServletContext servletContext, String resource) {
        String resourceAttributeName = RESOURCE_URL_ATTR_BASE + resource;
        String resourceUrl = (String)httpServletRequest.getAttribute(resourceAttributeName);
        if (resourceUrl != null) {
            return resourceUrl;
        }
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null && (resourceUrl = (String)session.getAttribute(resourceAttributeName)) != null) {
            return resourceUrl;
        }
        String resourceContextPath = servletContext.getInitParameter(RESOURCE_CONTEXT_INIT_PARAM);
        if (resourceContextPath == null) {
            resourceContextPath = DEFAULT_RESOURCE_CONTEXT;
        } else if (!resourceContextPath.startsWith("/")) {
            resourceContextPath = "/".concat(resourceContextPath);
        }
        ServletContext resourceContext = servletContext.getContext(resourceContextPath);
        if (resourceContext != null && resourceContextPath.equals(resourceContext.getContextPath())) {
            URL url = null;
            try {
                url = resourceContext.getResource(resource);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (url == null) {
                resourceContextPath = httpServletRequest.getContextPath();
            }
        } else {
            resourceContextPath = httpServletRequest.getContextPath();
        }
        resourceUrl = resourceContextPath.concat(resource);
        httpServletRequest.setAttribute(resourceAttributeName, (Object)resourceUrl);
        if (session != null) {
            session.setAttribute(resourceAttributeName, (Object)resourceUrl);
        }
        return resourceUrl;
    }

    public int doEndTag() throws JspException {
        if (this._var == null) {
            JspWriter out = this.pageContext.getOut();
            try {
                out.print(this._url);
            }
            catch (IOException e) {
                throw new JspTagException("Error writing URL to page.", (Throwable)e);
            }
        } else {
            this.pageContext.setAttribute(this._var, (Object)this._url);
        }
        return 6;
    }

    public String getVar() {
        return this._var;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public String getValue() {
        return this._resource;
    }

    public void setValue(String resource) {
        this._resource = !resource.startsWith("/") ? "/".concat(resource) : resource;
    }

    public String getUrl() {
        return this._url;
    }
}

