/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.boot.configuration;

import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.authentication.Saml11AuthenticationFilter;
import org.jasig.cas.client.boot.configuration.CasClientConfigurationProperties;
import org.jasig.cas.client.boot.configuration.CasClientConfigurer;
import org.jasig.cas.client.boot.configuration.EnableCasClient;
import org.jasig.cas.client.boot.configuration.SpringSecurityAssertionSessionContextFilter;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.jasig.cas.client.util.AssertionThreadLocalFilter;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.jasig.cas.client.validation.Cas30ProxyReceivingTicketValidationFilter;
import org.jasig.cas.client.validation.Saml11TicketValidationFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.cas.userdetails.GrantedAuthorityFromAssertionAttributesUserDetailsService;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={CasClientConfigurationProperties.class})
public class CasClientConfiguration {
    @Autowired
    CasClientConfigurationProperties configProps;
    private CasClientConfigurer casClientConfigurer;

    private static Map<String, String> constructInitParams(String casUrlParamName, String casUrlParamVal, String clientHostUrlVal) {
        HashMap<String, String> initParams = new HashMap<String, String>(2);
        initParams.put(casUrlParamName, casUrlParamVal);
        initParams.put("serverName", clientHostUrlVal);
        return initParams;
    }

    private static void initFilter(FilterRegistrationBean filterRegistrationBean, Filter targetFilter, int filterOrder, Map<String, String> initParams, List<String> urlPatterns) {
        filterRegistrationBean.setFilter(targetFilter);
        filterRegistrationBean.setOrder(filterOrder);
        filterRegistrationBean.setInitParameters(initParams);
        if (!urlPatterns.isEmpty()) {
            filterRegistrationBean.setUrlPatterns(urlPatterns);
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="cas", name={"skipTicketValidation"}, havingValue="false", matchIfMissing=true)
    public FilterRegistrationBean casValidationFilter() {
        Cas20ProxyReceivingTicketValidationFilter targetCasValidationFilter;
        FilterRegistrationBean validationFilter = new FilterRegistrationBean();
        switch (this.configProps.getValidationType()) {
            case CAS: {
                targetCasValidationFilter = new Cas20ProxyReceivingTicketValidationFilter();
                break;
            }
            case SAML: {
                targetCasValidationFilter = new Saml11TicketValidationFilter();
                break;
            }
            default: {
                targetCasValidationFilter = new Cas30ProxyReceivingTicketValidationFilter();
            }
        }
        CasClientConfiguration.initFilter(validationFilter, (Filter)targetCasValidationFilter, 1, CasClientConfiguration.constructInitParams(ConfigurationKeys.CAS_SERVER_URL_PREFIX.getName(), this.configProps.getServerUrlPrefix(), this.configProps.getClientHostUrl()), this.configProps.getValidationUrlPatterns());
        if (this.configProps.getUseSession() != null) {
            validationFilter.getInitParameters().put(ConfigurationKeys.USE_SESSION.getName(), String.valueOf(this.configProps.getUseSession()));
        }
        if (this.configProps.getRedirectAfterValidation() != null) {
            validationFilter.getInitParameters().put(ConfigurationKeys.REDIRECT_AFTER_VALIDATION.getName(), String.valueOf(this.configProps.getRedirectAfterValidation()));
        }
        if (this.configProps.getHostnameVerifier() != null) {
            validationFilter.getInitParameters().put(ConfigurationKeys.HOSTNAME_VERIFIER.getName(), this.configProps.getHostnameVerifier());
        }
        if (this.configProps.getSslConfigFile() != null) {
            validationFilter.getInitParameters().put(ConfigurationKeys.SSL_CONFIG_FILE.getName(), this.configProps.getSslConfigFile());
        }
        if (this.configProps.getAcceptAnyProxy() != null) {
            validationFilter.getInitParameters().put(ConfigurationKeys.ACCEPT_ANY_PROXY.getName(), String.valueOf(this.configProps.getAcceptAnyProxy()));
        }
        if (!this.configProps.getAllowedProxyChains().isEmpty()) {
            validationFilter.getInitParameters().put(ConfigurationKeys.ALLOWED_PROXY_CHAINS.getName(), StringUtils.collectionToDelimitedString(this.configProps.getAllowedProxyChains(), (String)" "));
        }
        if (this.configProps.getProxyCallbackUrl() != null) {
            validationFilter.getInitParameters().put(ConfigurationKeys.PROXY_CALLBACK_URL.getName(), this.configProps.getProxyCallbackUrl());
        }
        if (this.configProps.getProxyReceptorUrl() != null) {
            validationFilter.getInitParameters().put(ConfigurationKeys.PROXY_RECEPTOR_URL.getName(), this.configProps.getProxyReceptorUrl());
        }
        if (this.casClientConfigurer != null) {
            this.casClientConfigurer.configureValidationFilter(validationFilter);
        }
        return validationFilter;
    }

    @Bean
    public FilterRegistrationBean casAuthenticationFilter() {
        FilterRegistrationBean authnFilter = new FilterRegistrationBean();
        AuthenticationFilter targetCasAuthnFilter = this.configProps.getValidationType() == EnableCasClient.ValidationType.CAS || this.configProps.getValidationType() == EnableCasClient.ValidationType.CAS3 ? new AuthenticationFilter() : new Saml11AuthenticationFilter();
        CasClientConfiguration.initFilter(authnFilter, (Filter)targetCasAuthnFilter, 2, CasClientConfiguration.constructInitParams(ConfigurationKeys.CAS_SERVER_LOGIN_URL.getName(), this.configProps.getServerLoginUrl(), this.configProps.getClientHostUrl()), this.configProps.getAuthenticationUrlPatterns());
        if (this.configProps.getGateway() != null) {
            authnFilter.getInitParameters().put(ConfigurationKeys.GATEWAY.getName(), String.valueOf(this.configProps.getGateway()));
        }
        if (this.casClientConfigurer != null) {
            this.casClientConfigurer.configureAuthenticationFilter(authnFilter);
        }
        return authnFilter;
    }

    @Bean
    public FilterRegistrationBean casHttpServletRequestWrapperFilter() {
        FilterRegistrationBean reqWrapperFilter = new FilterRegistrationBean();
        reqWrapperFilter.setFilter((Filter)new HttpServletRequestWrapperFilter());
        if (!this.configProps.getRequestWrapperUrlPatterns().isEmpty()) {
            reqWrapperFilter.setUrlPatterns(this.configProps.getRequestWrapperUrlPatterns());
        }
        reqWrapperFilter.setOrder(3);
        if (this.casClientConfigurer != null) {
            this.casClientConfigurer.configureHttpServletRequestWrapperFilter(reqWrapperFilter);
        }
        return reqWrapperFilter;
    }

    @Bean
    public FilterRegistrationBean casAssertionThreadLocalFilter() {
        FilterRegistrationBean assertionTLFilter = new FilterRegistrationBean();
        assertionTLFilter.setFilter((Filter)new AssertionThreadLocalFilter());
        if (!this.configProps.getAssertionThreadLocalUrlPatterns().isEmpty()) {
            assertionTLFilter.setUrlPatterns(this.configProps.getAssertionThreadLocalUrlPatterns());
        }
        assertionTLFilter.setOrder(4);
        if (this.casClientConfigurer != null) {
            this.casClientConfigurer.configureAssertionThreadLocalFilter(assertionTLFilter);
        }
        return assertionTLFilter;
    }

    @Autowired(required=false)
    void setConfigurers(Collection<CasClientConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException(configurers.size() + " implementations of CasClientConfigurer were found when only 1 was expected. Refactor the configuration such that CasClientConfigurer is implemented only once or not at all.");
        }
        this.casClientConfigurer = configurers.iterator().next();
    }

    @Bean
    @ConditionalOnProperty(prefix="cas", value={"single-logout.enabled"}, havingValue="true")
    public FilterRegistrationBean casSingleSignOutFilter() {
        FilterRegistrationBean singleSignOutFilter = new FilterRegistrationBean();
        singleSignOutFilter.setFilter((Filter)new SingleSignOutFilter());
        HashMap<String, String> initParameters = new HashMap<String, String>(1);
        initParameters.put(ConfigurationKeys.CAS_SERVER_URL_PREFIX.getName(), this.configProps.getServerUrlPrefix());
        singleSignOutFilter.setInitParameters(initParameters);
        singleSignOutFilter.setOrder(Integer.MIN_VALUE);
        return singleSignOutFilter;
    }

    @Bean
    @ConditionalOnProperty(prefix="cas", value={"single-logout.enabled"}, havingValue="true")
    public ServletListenerRegistrationBean<EventListener> casSingleSignOutListener() {
        ServletListenerRegistrationBean singleSignOutListener = new ServletListenerRegistrationBean();
        singleSignOutListener.setListener((EventListener)new SingleSignOutHttpSessionListener());
        singleSignOutListener.setOrder(Integer.MIN_VALUE);
        return singleSignOutListener;
    }

    @Configuration
    @EnableConfigurationProperties(value={CasClientConfigurationProperties.class})
    @ConditionalOnClass(value={CasAuthenticationToken.class})
    @ConditionalOnProperty(prefix="cas", value={"use-session"}, havingValue="true", matchIfMissing=true)
    public class SpringSecurityAssertionAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"springSecurityAssertionSessionContextFilter"})
        public FilterRegistrationBean springSecurityAssertionSessionContextFilter() {
            FilterRegistrationBean filter = new FilterRegistrationBean();
            filter.setFilter((Filter)new SpringSecurityAssertionSessionContextFilter(this.springSecurityCasUserDetailsService(), new String[0]));
            filter.setEnabled(!CasClientConfiguration.this.configProps.getAttributeAuthorities().isEmpty());
            filter.setOrder(0);
            if (CasClientConfiguration.this.casClientConfigurer != null) {
                CasClientConfiguration.this.casClientConfigurer.configureHttpServletRequestWrapperFilter(filter);
            }
            return filter;
        }

        @Bean
        @ConditionalOnMissingBean(name={"springSecurityCasUserDetailsService"})
        public AuthenticationUserDetailsService<CasAssertionAuthenticationToken> springSecurityCasUserDetailsService() {
            return new GrantedAuthorityFromAssertionAttributesUserDetailsService(CasClientConfiguration.this.configProps.getAttributeAuthorities().toArray(new String[0]));
        }
    }
}

