/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.tomcat.CasRealm;
import org.jasig.cas.client.util.CommonUtils;

public class PropertiesCasRealmDelegate
implements CasRealm {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertiesFilePath;
    private Map<String, Set<String>> roleMap;

    public void setPropertiesFilePath(String path) {
        this.propertiesFilePath = path;
    }

    public void readProperties() {
        CommonUtils.assertNotNull((Object)this.propertiesFilePath, (String)"PropertiesFilePath not set.");
        File file = new File(this.propertiesFilePath);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.propertiesFilePath);
        }
        CommonUtils.assertTrue((boolean)file.exists(), (String)("File not found " + file));
        CommonUtils.assertTrue((boolean)file.canRead(), (String)("Cannot read " + file));
        this.log.debug((Object)("Loading users/roles from " + file));
        Properties properties = new Properties();
        try {
            properties.load(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Error loading users/roles from " + file, e);
        }
        this.roleMap = new HashMap<String, Set<String>>(properties.size());
        for (Object key : properties.keySet()) {
            String user = (String)key;
            HashSet<String> roleSet = new HashSet<String>();
            String[] roles = properties.getProperty(user).split(",\\s*");
            roleSet.addAll(Arrays.asList(roles));
            this.roleMap.put(user, roleSet);
        }
    }

    public Principal authenticate(Principal p) {
        if (this.roleMap.containsKey(p.getName())) {
            return p;
        }
        return null;
    }

    public String[] getRoles(Principal p) {
        Set<String> roleSet = this.roleMap.get(p.getName());
        return roleSet.toArray(new String[roleSet.size()]);
    }

    public boolean hasRole(Principal principal, String role) {
        Set<String> roles = this.roleMap.get(principal.getName());
        return roles != null && roles.contains(role);
    }
}

