/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.jetty;

import java.security.Principal;
import java.util.Collection;
import javax.security.auth.Subject;
import org.eclipse.jetty.server.UserIdentity;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;

public class CasUserIdentity
implements UserIdentity {
    private final AttributePrincipal principal;
    private final String roleAttribute;

    public CasUserIdentity(Assertion assertion, String roleAttribute) {
        CommonUtils.assertNotNull((Object)assertion, (String)"Assertion cannot be null");
        this.principal = assertion.getPrincipal();
        this.roleAttribute = roleAttribute;
    }

    public Subject getSubject() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)this.principal);
        return subject;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role, UserIdentity.Scope scope) {
        if (this.roleAttribute != null) {
            Object value = this.principal.getAttributes().get(this.roleAttribute);
            if (value instanceof Collection) {
                return ((Collection)value).contains(role);
            }
            if (value instanceof String) {
                return value.equals(role);
            }
        }
        return false;
    }

    public String toString() {
        return this.principal.getName();
    }
}

