/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.jetty;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.jetty.CasAuthentication;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.AbstractCasProtocolUrlBasedTicketValidator;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticator
extends AbstractLifeCycle
implements Authenticator {
    public static final String AUTH_METHOD = "CAS";
    private static final String CACHED_AUTHN_ATTRIBUTE = "org.jasig.cas.client.jetty.Authentication";
    private final Logger logger = LoggerFactory.getLogger(CasAuthenticator.class);
    private final ConcurrentMap<String, WeakReference<HttpSession>> sessionMap = new ConcurrentHashMap<String, WeakReference<HttpSession>>();
    private TicketValidator ticketValidator;
    private String serverNames;
    private String roleAttribute;
    private String casServerLoginUrl;
    private Protocol protocol;
    private boolean renew;

    public void setTicketValidator(TicketValidator ticketValidator) {
        CommonUtils.assertNotNull((Object)ticketValidator, (String)"TicketValidator cannot be null");
        if (!(ticketValidator instanceof AbstractUrlBasedTicketValidator)) {
            throw new IllegalArgumentException("Unsupported ticket validator " + ticketValidator);
        }
        this.protocol = ticketValidator instanceof AbstractCasProtocolUrlBasedTicketValidator ? Protocol.CAS2 : Protocol.SAML11;
        this.casServerLoginUrl = ReflectUtils.getField((String)"casServerUrlPrefix", (Object)ticketValidator) + "/login";
        this.renew = (Boolean)ReflectUtils.getField((String)"renew", (Object)ticketValidator);
        this.ticketValidator = ticketValidator;
    }

    public void setServerNames(String nameList) {
        CommonUtils.isNotBlank((String)nameList);
        this.serverNames = nameList;
    }

    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    public void setRoleAttribute(String roleAttribute) {
        CommonUtils.isNotBlank((String)roleAttribute);
        this.roleAttribute = roleAttribute;
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
    }

    public String getAuthMethod() {
        return AUTH_METHOD;
    }

    public void prepareRequest(ServletRequest request) {
    }

    public Authentication validateRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        CasAuthentication authentication = this.fetchCachedAuthentication(request);
        if (authentication != null) {
            return authentication;
        }
        String ticket = request.getParameter(this.protocol.getArtifactParameterName());
        if (ticket != null && mandatory) {
            try {
                this.logger.debug("Attempting to validate {}", (Object)ticket);
                Assertion assertion = this.ticketValidator.validate(ticket, this.serviceUrl(request, response));
                this.logger.info("Successfully authenticated {}", (Object)assertion.getPrincipal());
                authentication = new CasAuthentication(this, ticket, assertion);
                this.cacheAuthentication(request, authentication);
            }
            catch (Exception e) {
                throw new ServerAuthException("CAS ticket validation failed", (Throwable)e);
            }
        }
        if (authentication != null) {
            return authentication;
        }
        if (mandatory) {
            this.redirectToCas(request, response);
            return Authentication.SEND_CONTINUE;
        }
        return Authentication.UNAUTHENTICATED;
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User user) throws ServerAuthException {
        return true;
    }

    protected void doStart() throws Exception {
        if (this.ticketValidator == null) {
            throw new RuntimeException("TicketValidator cannot be null");
        }
        if (this.serverNames == null) {
            throw new RuntimeException("ServerNames cannot be null");
        }
    }

    protected void clearCachedAuthentication(String ticket) {
        WeakReference sessionRef = (WeakReference)this.sessionMap.remove(ticket);
        if (sessionRef != null && sessionRef.get() != null) {
            ((HttpSession)sessionRef.get()).removeAttribute(CACHED_AUTHN_ATTRIBUTE);
        }
    }

    private void cacheAuthentication(HttpServletRequest request, CasAuthentication authentication) {
        HttpSession session = request.getSession(true);
        if (session != null) {
            session.setAttribute(CACHED_AUTHN_ATTRIBUTE, (Object)authentication);
            this.sessionMap.put(authentication.getTicket(), new WeakReference<HttpSession>(session));
        }
    }

    private CasAuthentication fetchCachedAuthentication(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return (CasAuthentication)((Object)session.getAttribute(CACHED_AUTHN_ATTRIBUTE));
        }
        return null;
    }

    private String serviceUrl(HttpServletRequest request, HttpServletResponse response) {
        return CommonUtils.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response, null, (String)this.serverNames, (String)this.protocol.getServiceParameterName(), (String)this.protocol.getArtifactParameterName(), (boolean)true);
    }

    private void redirectToCas(HttpServletRequest request, HttpServletResponse response) throws ServerAuthException {
        try {
            String redirectUrl = CommonUtils.constructRedirectUrl((String)this.casServerLoginUrl, (String)this.protocol.getServiceParameterName(), (String)this.serviceUrl(request, response), (boolean)this.renew, (boolean)false, null);
            this.logger.debug("Redirecting to {}", (Object)redirectUrl);
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            this.logger.debug("Redirect to CAS failed with error", (Throwable)e);
            throw new ServerAuthException("Redirect to CAS failed", (Throwable)e);
        }
    }
}

