/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.jetty;

import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.server.UserIdentity;
import org.jasig.cas.client.jetty.CasAuthenticator;
import org.jasig.cas.client.jetty.CasUserIdentity;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;

public class CasAuthentication
extends UserAuthentication {
    private final CasAuthenticator authenticator;
    private final String ticket;

    public CasAuthentication(CasAuthenticator authenticator, String ticket, Assertion assertion) {
        super(authenticator.getAuthMethod(), (UserIdentity)new CasUserIdentity(assertion, authenticator.getRoleAttribute()));
        CommonUtils.assertNotNull((Object)ticket, (String)"Ticket cannot be null");
        CommonUtils.assertNotNull((Object)((Object)authenticator), (String)"CasAuthenticator cannot be null");
        this.authenticator = authenticator;
        this.ticket = ticket;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void logout() {
        super.logout();
        this.authenticator.clearCachedAuthentication(this.ticket);
    }
}

