/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.integration.atlassian;

import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.UserManager;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JiraCasAuthenticator
extends DefaultAuthenticator {
    private static final long serialVersionUID = 3452011252741183166L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraCasAuthenticator.class);

    protected boolean authenticate(Principal principal, String password) throws AuthenticatorException {
        return true;
    }

    protected Principal getUser(String username) {
        try {
            return UserManager.getInstance().getUser(username);
        }
        catch (EntityNotFoundException e) {
            LOGGER.warn("Could not find user '{}' in UserManager : {}", (Object)username, (Object)e);
            return null;
        }
    }

    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        if (session.getAttribute("seraph_defaultauthenticator_user") != null) {
            LOGGER.debug("Session found; user already logged in.");
            return (Principal)session.getAttribute("seraph_defaultauthenticator_user");
        }
        Assertion assertion = (Assertion)session.getAttribute("_const_cas_assertion_");
        if (assertion != null) {
            Principal p = this.getUser(assertion.getPrincipal().getName());
            LOGGER.debug("Logging in [{}] from CAS.", (Object)p.getName());
            session.setAttribute("seraph_defaultauthenticator_user", (Object)p);
            session.setAttribute("seraph_defaultauthenticator_logged_out_user", null);
            return p;
        }
        return super.getUser(request, response);
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        HttpSession session = request.getSession();
        Principal p = (Principal)session.getAttribute("seraph_defaultauthenticator_user");
        LOGGER.debug("Logging out [{}] from CAS.", (Object)p.getName());
        session.setAttribute("seraph_defaultauthenticator_logged_out_user", (Object)p);
        session.setAttribute("seraph_defaultauthenticator_user", null);
        session.setAttribute("_const_cas_assertion_", null);
        return true;
    }
}

