/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.integration.atlassian;

import com.atlassian.jira.security.login.JiraSeraphAuthenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.LoginReason;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jira44CasAuthenticator
extends JiraSeraphAuthenticator {
    private static final long serialVersionUID = 3852011252741183166L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Jira44CasAuthenticator.class);

    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session;
        Assertion assertion;
        Principal existingUser = this.getUserFromSession(request);
        if (existingUser != null) {
            LOGGER.debug("Session found; user already logged in.");
        }
        if ((assertion = (Assertion)(session = request.getSession()).getAttribute("_const_cas_assertion_")) != null) {
            String username = assertion.getPrincipal().getName();
            Principal user = this.getUser(username);
            if (user != null) {
                this.putPrincipalInSessionContext(request, user);
                this.getElevatedSecurityGuard().onSuccessfulLoginAttempt(request, username);
                LoginReason.OK.stampRequestResponse(request, response);
                LOGGER.debug("Logging in [{}] from CAS.", (Object)username);
            } else {
                LOGGER.debug("Failed logging [{}] from CAS.", (Object)username);
                this.getElevatedSecurityGuard().onFailedLoginAttempt(request, username);
            }
            return user;
        }
        return super.getUser(request, response);
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        HttpSession session = request.getSession();
        Principal p = (Principal)session.getAttribute("seraph_defaultauthenticator_user");
        if (p != null) {
            LOGGER.debug("Logging out [{}] from CAS.", (Object)p.getName());
        }
        this.removePrincipalFromSessionContext(request);
        session.setAttribute("_const_cas_assertion_", null);
        return true;
    }
}

